% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bills_cosponsored_member.R
\name{get_bills_cosponsored_member}
\alias{get_bills_cosponsored_member}
\title{Get Bills Cosponsored by a Specific Member}
\usage{
get_bills_cosponsored_member(member_id, type = c("cosponsored",
  "withdrawn"), myAPI_Key)
}
\arguments{
\item{member_id}{The ID of the member to retrieve; it is assigned by the Biographical Directory of the United States Congress or can be retrieved from a member list request.}

\item{type}{cosponsored or withdrawn}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent bill cosponsorships for a particular member
}
\description{
To get the 20 most recent bill cosponsorships for a particular member, either bills cosponsored or bills where cosponsorship was withdrawn. #HTTP Request: GET https://api.propublica.org/congress/v1/members/{member-id}/bills/{type}.json
}
\examples{
\donttest{
get_bills_cosponsored_member('B001260', 'cosponsored')
}
}
