#' Get Related Bills for a Specific Bill
#'
#' HTTP Request: GET hhttps://api.propublica.org/congress/v1/{congress}/bills/{bill-id}/related.json. Use this request type to get Library of Congress-identified related bills for a particular bill. 
#'
#' @param bill_id a bill slug, for example hr4881 - these can be found in the recent bill response.
#' @param congress 105-115
#' @inheritParams get_new_members
#'
#' @return  List of returned JSON from endpoint that retrieves the 20 most recent results and supports paginated requests.
#' 
#' @export
#'
#' @examples
#' \donttest{
#' get_related_bills(115, 'hr3219')
#' }
get_related_bills <- function(congress, bill_id, myAPI_Key){
  API = 'congress'
  if(!congress %in% 105:115){
    stop("Congress has to be 105-115")
  }
  if(is.character(bill_id)){
    query <- sprintf("%s/bills/%s/related.json", congress, bill_id)
    pp_query(query, API, myAPI_Key = myAPI_Key)
  } else {stop("bill_id has to be character")}
}