% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/visualization.R
\name{visualization}
\alias{visualization}
\title{Network visualization}
\usage{
visualization(graph, layout = c("reingold.tilford", "circle", "random",
  "fruchterman.reingold", "sphere", "kamada.kawai", "lgl"),
  node.fill.color = "SkyBlue2", node.border.color = "Black",
  node.shape = c("circle", "square", "sphere", "csquare", "rectangle",
  "crectangle", "vrectangle", "none", "pie", "raster"), node.size = 15,
  node.label = "name", node.label.color = 1, node.label.size = 0.8,
  node.label.position = 0, edge.shape = 1, edge.width = 1,
  edge.color = "gray1", ...)
}
\arguments{
\item{graph}{An igraph object.}

\item{layout}{Mode of the layout, possible values are \code{fruchterman.reingold}, \code{reingold.tilford}, \code{random}, \code{circle}, \code{kamada.kawai}, \code{lgl} and \code{sphere}. See \pkg{igraph} for more information.}

\item{node.fill.color}{The fill color of the vertex. Default value is \code{SkyBlue2}.}

\item{node.border.color}{Border color the the vertex. Default value is \code{Black}.}

\item{node.shape}{Shape of the vertex. currently \code{circle}, \code{square}, \code{csquare}, \code{rectangle}, \code{crectangl}, \code{vrectangle} and \code{none} are supported.}

\item{node.size}{Size of the vertex. Default value is \code{15}.}

\item{node.label}{Label of the vertex. Specify \code{NA} to omit vertex labels. Default value is the vertex name.}

\item{node.label.color}{Color of labels of the vertex. Default value is \code{1}.}

\item{node.label.size}{Font size of the vertex label. Default value is \code{0.8}.}

\item{node.label.position}{Positon of the vertex label. Default value is \code{0}.}

\item{edge.shape}{Shape of the edge. Default value is \code{1}.}

\item{edge.width}{Width of the edge. Default value is \code{1}.}

\item{edge.color}{Color of the edge. Default value is \code{gray1}.}

\item{...}{Other arguments.}
}
\value{
A plot of the network.
}
\description{
This function takes an igraph formatted network as input and exports a picture of the visulization. Mode of the layout, and size, color, shape of the nodes, edges and labels can be set according to the experiment data.
}
\examples{
local<-data.frame(1:5,2:6)
attribute<-data.frame(node=1:6,value=c(2.2,5.3,1.2,4.5,6.2,0.6))
net<-construction(input=local,local.net=TRUE,node.attribute=attribute)
visualization(net,layout="reingold.tilford")
visualization(net,layout="reingold.tilford",node.size=V(net)$value)
}

