% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/opt.landgen.r
\name{opt.landgen}
\alias{opt.landgen}
\title{Function for optimising a landscape genetic analysis based on resistance layers}
\usage{
opt.landgen(landscape, nlocations, mindist = 0, fixed = NULL, method,
  NN = 8, iter = 100, retry = 10, mask = NULL, plot = TRUE)
}
\arguments{
\item{landscape}{resistance layer as a raster object (if not projected dimensions are assumed to be in meters!!)}

\item{nlocations}{the number of locations}

\item{mindist}{minimal distance in map units (meter if not specified)}

\item{fixed}{n fixed locations, provided as a data.frame with dimenstions nx2}

\item{method}{least cost path algorithm provided by the gdistance package. Options are "leastcost", "SPDistance" and "commute". see function costdistances.}

\item{NN}{number of next neighboring cells to be used, default is 8. see function costdistances.}

\item{iter}{number of iterations that should be used to find an optimised design. Try initially the default and if it runs fast (depends on the type of costdistance an d dimenstions of landscape), increase to higher values.}

\item{retry}{number of retries if optimisation is not possible in a certain iteration (due to mindist and/or fixed locations). Defaults to 10, which should be sufficient in most cases.}

\item{mask}{a raster object that masks positions which are not available. Areas which are not to be used for locations are coded as NA (not available), all other values are treated as suitable for placing locations.}

\item{plot}{if true, some plots are presented that show the histogramm, ecdf of the best (and the worst scenario).}
}
\value{
a list object with two slots. The first slot is called opt and contains iter optimisation values (sd.detour and sd.cost) in a iter x 2 dimenstional data.frame. The second slot is called scenario and contains the corrosponding 1:iter scenarios, given as coordinates in a data.frame of dimensions nlocations x 2. Both slots are ordered in decreasing order of sd.detour values. So the best scenario is at 1 and the worst is at position iter.
}
\description{
opt.landgen places iter times nlocations in a given landscape. For each scenario the pairwise costdistances and Euclidean distances are calculated and the standard deviation of detour (see Gruber et al. in prep) is calculated. This metric evaluates the scenerio in their ability to find a significant effect for the given resistance layer on population structure (based on the causal modelling approach of Cushman et al.). To allow for more realistic designs previously locations, a minimal distance between locations and a mask that indicates "forbidden" areas can be specified.
}

