% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dif_stats.R
\name{Dif_stats}
\alias{Dif_stats}
\title{A function to calculate differentiation statistics and perform significance testing with a vcf file.}
\usage{
Dif_stats(
  VCF,
  pops,
  ploidy,
  statistic = "both",
  boots,
  write = FALSE,
  prefix = NULL
)
}
\arguments{
\item{VCF}{Character string indicating the name of the vcf file to be used in analysis.}

\item{pops}{Character string indicating the name of the population assignment file. This file should have four columns and be in the same order as your vcf file. The first column named Sample indicates the sample name. The second column named Population indicates the population assignment of each individual. The third column named Long indicates the longitude of the sample.  The fourth column named Lat indicates the latitude of the sample.}

\item{ploidy}{Numeric. The ploidy of the data.}

\item{statistic}{Character string. Options are both, FST, and NeisD.}

\item{boots}{Numeric. The number of boostraps to use to evaluate statistical significance. Only relevant for FST estimation.}

\item{write}{Boolean. Whether or not to write the output to a file in the current working directory.}

\item{prefix}{Character string that will be appended to file output.}
}
\value{
A list contianing data frames for the requested statistic.
}
\description{
A function to calculate differentiation statistics and perform significance testing with a vcf file.
}
\examples{
\donttest{
data("HornedLizard_Pop")
data("HornedLizard_VCF")
Test <- Dif_stats(VCF = HornedLizard_VCF, pops = HornedLizard_Pop,
ploidy = 2, statistic = "both", boots = 10, write = FALSE)}
}
