% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_nail_condes.R
\name{shiny_nail_condes}
\alias{shiny_nail_condes}
\title{Launch a Shiny app for interpreting a (latent) continuous variable}
\usage{
shiny_nail_condes(dataset)
}
\arguments{
\item{dataset}{A data frame containing the continuous variable to be analyzed.}
}
\value{
This function does not return a value; it launches a Shiny app.
}
\description{
This function launches a Shiny app for interpreting a (latent)
continuous variable with the 'Nailer' package.
}
\examples{
if(interactive()){
# Processing time is often longer than ten seconds
# because the function uses a large language model.

library(FactoMineR)
library(stringr)
library(NaileR)
data(beard_cont)

res_ca_beard <- FactoMineR::CA(beard_cont, graph = FALSE)

beard_work <- res_ca_beard$row$coord |> as.data.frame()
beard_work <- beard_work[,1] |> cbind(beard_cont)

intro_beard <- "These data refer to 8 types of beards.
Each beard was evaluated by 62 assessors."
intro_beard <- gsub('\n', ' ', intro_beard) |>
stringr::str_squish()

req_beard <- "Please explain what differentiates beards
on both sides of the scale.
Then, give the scale a name."
req_beard <- gsub('\n', ' ', req_beard) |>
stringr::str_squish()

shiny_nail_condes(beard_work)

}
}
