% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_docs.R
\name{shelter.find}
\alias{shelter.find}
\title{Returns a data.frame of shelter records matching input parameters.}
\usage{
shelter.find(location, name = NULL, offset = NULL, count = NULL,
  pages = NULL, return_df = FALSE)
}
\arguments{
\item{location}{ZIP/postal code, state, or city and state to perform the
search.}

\item{name}{Full or partial shelter name}

\item{offset}{Can be set to the value of lastOffset returned from the
previous call to retrieve the next set of results. The pages parameter can
also be used to pull a desired number of paged results.}

\item{count}{The number of records to return. Default is 25.}

\item{pages}{The number of pages of results to return. For example, if
pages=4 with the default count parameter (25), 125 results would be
returned (25 results from first call and 100 from the next four pages).}

\item{return_df}{If TRUE, the function will coerce the output JSON from the
Petfinder API into a data.frame}
}
\value{
List of returned JSON from the Petfinder API. If the parameter
  return_df is TRUE, a data.frame is returned instead.
}
\description{
Returns a data.frame of shelter records matching input parameters.
}
\examples{
\dontrun{
pf <- Petfinder(key) # Initialize Petfinder class
pf$shelter.find('WA', count = 5)
pf$shelter.find('WA', pages = 3)
}
}
