% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.CaptureRatios.R, R/table.UpDownRatios.R
\name{table.CaptureRatios}
\alias{table.CaptureRatios}
\alias{table.UpDownRatios}
\alias{table.UpDownRatios}
\title{Calculate and display a table of capture ratio and related statistics}
\usage{
table.CaptureRatios(Ra, Rb, digits = 4)

table.UpDownRatios(Ra, Rb, digits = 4)
}
\arguments{
\item{Ra}{a vector of returns to test, e.g., the asset to be examined}

\item{Rb}{a matrix, data.frame, or timeSeries of benchmark(s) to test the
asset against.}

\item{digits}{number of digits to round results to for presentation}
}
\description{
Creates a table of capture ratios and similar metrics for a set of returns
against a benchmark.
}
\details{
This table will show statistics pertaining to an asset against a set of
benchmarks, or statistics for a set of assets against a benchmark.
\code{table.CaptureRatios} shows only the capture ratio;
\code{table.UpDownRatios} shows three: the capture ratio, the number ratio,
and the percentage ratio.
}
\examples{

data(managers)
table.CaptureRatios(managers[,1:6], managers[,7,drop=FALSE])
table.UpDownRatios(managers[,1:6], managers[,7,drop=FALSE])

result = t(table.UpDownRatios(managers[,1:6], managers[,7,drop=FALSE])) 
colnames(result)=colnames(managers[,1:6])
textplot(result, rmar = 0.8, cmar = 1.5,  max.cex=.9, 
         halign = "center", valign = "top", row.valign="center", 
         wrap.rownames=15, wrap.colnames=10, mar = c(0,0,3,0)+0.1)
         
title(main="Capture Ratios for EDHEC LS EQ")

}
\seealso{
\code{\link{UpDownRatios}}, \code{\link{chart.CaptureRatios}}
}
\author{
Peter Carl
}
