% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aindex.R
\name{aIndex}
\alias{aIndex}
\title{Compute the aliphatic index of a protein sequence}
\usage{
aIndex(seq)
}
\arguments{
\item{seq}{An amino-acids sequence}
}
\value{
The computed aliphatic index for a given amino-acids sequence
}
\description{
This function calculates the Ikai (1980) aliphatic index of a protein. The \code{aindex} is defined as the relative volume occupied by aliphatic side chains (Alanine, Valine, Isoleucine, and Leucine). It may be regarded as a positive factor for the increase of thermostability of globular proteins.
}
\details{
Aliphatic amino acids (A, I, L and V) are responsible for the thermal stability of proteins. The aliphatic index was proposed by Ikai (1980) and evaluates the thermostability of proteins based on the percentage of each of the aliphatic amino acids that build up proteins.
}
\examples{
# COMPARED TO ExPASy ALIPHATIC INDEX
# http://web.expasy.org/protparam/
# SEQUENCE: SDKEVDEVDAALSDLEITLE
# Aliphatic index: 117.00

aIndex(seq = "SDKEVDEVDAALSDLEITLE")
# [1] 117
}
\references{
Ikai (1980). Thermostability and aliphatic index of globular proteins. Journal of Biochemistry, 88(6), 1895-1898.
}
