% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addConceptIntersect.R
\name{addConceptIntersectDays}
\alias{addConceptIntersectDays}
\title{It creates column to indicate the days of difference from an index date to a
concept}
\usage{
addConceptIntersectDays(
  x,
  conceptSet,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  window = list(c(0, Inf)),
  targetDate = "event_start_date",
  order = "first",
  nameStyle = "{concept_name}_{window_name}"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{conceptSet}{Concept set list.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a date column of x}

\item{window}{window to consider events in.}

\item{targetDate}{Event date to use for the intersection.}

\item{order}{last or first date to use for date/days calculations.}

\item{nameStyle}{naming of the added column or columns, should include
required parameters.}
}
\value{
table with added columns with overlap information
}
\description{
It creates column to indicate the days of difference from an index date to a
concept
}
\examples{
\donttest{
library(PatientProfiles)
cdm <- mockPatientProfiles()
concept <- dplyr::tibble(
  concept_id = c(1125315),
  domain_id = "Drug",
  vocabulary_id = NA_character_,
  concept_class_id = "Ingredient",
  standard_concept = "S",
  concept_code = NA_character_,
  valid_start_date = as.Date("1900-01-01"),
  valid_end_date = as.Date("2099-01-01"),
  invalid_reason = NA_character_
) \%>\%
  dplyr::mutate(concept_name = paste0("concept: ", .data$concept_id))
cdm <- CDMConnector::insertTable(cdm, "concept", concept)
result <- cdm$cohort1 \%>\%
  addConceptIntersectDays(
    conceptSet = list("acetaminophen" = 1125315)
  ) \%>\%
  dplyr::collect()
mockDisconnect(cdm = cdm)
}

}
