% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseLargeScaleCharacteristics.R
\name{addLargeScaleCharacteristics}
\alias{addLargeScaleCharacteristics}
\title{This function is used to add columns with the large scale characteristics of
a cohort table.}
\usage{
addLargeScaleCharacteristics(
  cohort,
  window = list(c(0, Inf)),
  eventInWindow = NULL,
  episodeInWindow = NULL,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  minimumFrequency = 0.005,
  excludedCodes = NULL
)
}
\arguments{
\item{cohort}{The cohort to characterise.}

\item{window}{Temporal windows that we want to characterize.}

\item{eventInWindow}{Tables to characterise the events in the window.}

\item{episodeInWindow}{Tables to characterise the episodes in the window.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a specific date
or a column date of x.}

\item{minimumFrequency}{Minimum frequency covariates to report.}

\item{excludedCodes}{Codes excluded.}
}
\value{
The output of this function is the cohort with the new created
columns.
}
\description{
This function is used to add columns with the large scale characteristics of
a cohort table.
}
\examples{
\donttest{
library(PatientProfiles)
cdm <- PatientProfiles::mockPatientProfiles()
results <- cdm$cohort2 \%>\%
  addLargeScaleCharacteristics(
  episodeInWindow = c("condition_occurrence"),
  minimumFrequency = 0
  )
CDMConnector::cdmDisconnect(cdm = cdm)
}

}
