% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCohortIntersect.R
\name{addCohortIntersectCount}
\alias{addCohortIntersectCount}
\title{It creates columns to indicate number of occurrences of intersection with a
cohort}
\usage{
addCohortIntersectCount(
  x,
  cdm = attr(x, "cdm_reference"),
  targetCohortTable,
  targetCohortId = NULL,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  targetStartDate = "cohort_start_date",
  targetEndDate = "cohort_end_date",
  window = list(c(0, Inf)),
  nameStyle = "{cohort_name}_{window_name}",
  tablePrefix = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm}

\item{cdm}{Object that contains a cdm reference. Use CDMConnector to obtain a
cdm reference.}

\item{targetCohortTable}{name of the cohort that we want to check for overlap}

\item{targetCohortId}{vector of cohort definition ids to include}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a specific date
or a column date of x}

\item{targetStartDate}{date of reference in cohort table, either for start
(in overlap) or on its own (for incidence)}

\item{targetEndDate}{date of reference in cohort table, either for end
(overlap) or NULL (if incidence)}

\item{window}{window to consider events of}

\item{nameStyle}{naming of the added column or columns, should include
required parameters}

\item{tablePrefix}{The stem for the permanent tables that will
be created. If NULL, temporary tables will be used throughout.}
}
\value{
table with added columns with overlap information
}
\description{
It creates columns to indicate number of occurrences of intersection with a
cohort
}
\examples{
\donttest{
library(PatientProfiles)
library(dplyr)

cohort1 <- dplyr::tibble(
  cohort_definition_id = c(1, 1, 1, 1, 1),
  subject_id = c(1, 1, 1, 2, 2),
  cohort_start_date = as.Date(
    c(
      "2020-01-01",
      "2020-01-15",
      "2020-01-20",
      "2020-01-01",
      "2020-02-01"
    )
  ),
  cohort_end_date = as.Date(
    c(
      "2020-01-01",
      "2020-01-15",
      "2020-01-20",
      "2020-01-01",
      "2020-02-01"
    )
  )
)

cohort2 <- dplyr::tibble(
  cohort_definition_id = c(1, 1, 1, 1, 1, 1, 1),
  subject_id = c(1, 1, 1, 2, 2, 2, 1),
  cohort_start_date = as.Date(
    c(
      "2020-01-15",
      "2020-01-25",
      "2020-01-26",
      "2020-01-29",
      "2020-03-15",
      "2020-01-24",
      "2020-02-16"
    )
  ),
  cohort_end_date = as.Date(
    c(
      "2020-01-15",
      "2020-01-25",
      "2020-01-26",
      "2020-01-29",
      "2020-03-15",
      "2020-01-24",
      "2020-02-16"
    )
  ),
)

cdm <- mockPatientProfiles(cohort1 = cohort1, cohort2 = cohort2)

result <- cdm$cohort1 \%>\%
  addCohortIntersectCount(
    targetCohortTable = "cohort2"
  ) \%>\%
  dplyr::collect()
}

}
