% Generated by roxygen2 (4.0.1): do not edit by hand
\name{Param}
\alias{Param}
\alias{makeDiscreteParam}
\alias{makeDiscreteVectorParam}
\alias{makeFunctionParam}
\alias{makeIntegerParam}
\alias{makeIntegerVectorParam}
\alias{makeLogicalParam}
\alias{makeLogicalVectorParam}
\alias{makeNumericParam}
\alias{makeNumericVectorParam}
\alias{makeUntypedParam}
\title{Create a description object for a parameter.}
\usage{
makeNumericParam(id, lower = -Inf, upper = Inf, default, trafo = NULL,
  requires = NULL)

makeNumericVectorParam(id, len, lower = -Inf, upper = Inf, default,
  trafo = NULL, requires = NULL)

makeIntegerParam(id, lower = -Inf, upper = Inf, default, trafo = NULL,
  requires = NULL)

makeIntegerVectorParam(id, len, lower = -Inf, upper = Inf, default,
  trafo = NULL, requires = NULL)

makeLogicalParam(id, default, requires = NULL)

makeLogicalVectorParam(id, len, default, requires = NULL)

makeDiscreteParam(id, values, trafo = NULL, default, requires = NULL)

makeDiscreteVectorParam(id, len, values, default, requires = NULL)

makeFunctionParam(id, default = default, requires = NULL)

makeUntypedParam(id, default, requires = NULL)
}
\arguments{
\item{id}{[\code{character(1)}]\cr
Name of parameter.}

\item{len}{[\code{integer(1)}]\cr
Length of vector parameter.}

\item{lower}{[\code{numeric}]\cr
Lower bounds.
A singe value of length 1 is automatically replicated to \code{len} for vector parameters.
Default is \code{-Inf}.}

\item{upper}{[\code{numeric}]\cr
Upper bounds.
A singe value of length 1 is automatically replicated to \code{len} for vector parameters.
Default is \code{Inf}.}

\item{values}{[\code{vector} | \code{list}]\cr
Possible discrete values. Instead of using a vector of atomic values,
you are also allowed to pass a list of quite \dQuote{complex} R objects,
which are used as discrete choices. If you do the latter,
the elements must be uniquely named, so that the names can be used
as internal represenatations for the choice.}

\item{default}{[any]\cr
Default value used in learner.
If this argument is missing, it means no default value is available.}

\item{trafo}{[\code{NULL} | \code{function(x)}]\cr
Function to transform parameter. It should be applied to the parameter value
before it is, e.g., passed to a corresponding objective function.
Function must accept a parameter value as the first argument and return a transformed one.
Default is \code{NULL} which means no transformation.}

\item{requires}{[\code{NULL} | R expression]\cr
States requirements on other paramaters' values, so that setting
this parameter only makes sense if its requirements are satisfied (dependent parameter).
Only really useful if the parameter is included in a \code{\link{ParamSet}}.
Default is \code{NULL} which means no requirements.}
}
\value{
[\code{\link{Param}}].
}
\description{
For each parameter type a special constructor function is available, see below.
}
\details{
The S3 class is a list which stores these elements:
\describe{
\item{id [\code{character(1)}]}{See argument of same name.}
\item{type [\code{character(1)}]}{Data type of parameter. Possible types are \dQuote{numeric}, \dQuote{numericvector}, \dQuote{integer}, \dQuote{integervector}, \dQuote{logical}, \dQuote{logicalvector}, \dQuote{discrete}, \dQuote{discretevector}, \dQuote{function}, \dQuote{untyped}.}
\item{len [\code{integer(1)}]}{See argument of same name.}
\item{lower [\code{numeric}]}{See argument of same name. Length of this vector is \code{len}.}
\item{upper [\code{numeric}]}{See argument of same name. Length of this vector is \code{len}.}
\item{values [\code{list}]}{Discrete values, always stored as a named list.}
\item{trafo [\code{NULL} | \code{function(x)}]}{See argument of same name.}
\item{requires [\code{NULL} | \code{expression}]}{See argument of same name.}
}
}
\examples{
makeNumericParam("x",lower = -1, upper = 1)
makeNumericVectorParam("x", len = 2)
makeDiscreteParam("y", values = c("a","b"))
}

