% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_timeAverage.R
\name{monitor_timeAverage}
\alias{monitor_timeAverage}
\title{Calculate Time Averages}
\usage{
monitor_timeAverage(ws_monitor, ...)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{...}{additional arguments to be passed to \code{openair::timeAverage()}}
}
\value{
A \emph{ws_monitor} object with data that have been proccessed by \code{openair::timeAverage()}.
}
\description{
This function extracts the \code{data} dataframe from \code{ws_monitor} object
and renames the \code{'datetime'} column so that it can be processed by the \pkg{openair} package's
\code{timeAverage()} function. (See that function for details.)
}
\examples{
library(PWFSLSmoke)

C_V <- monitor_subset(Carmel_Valley, tlim=c(2016080800,2016081023),
                      timezone='America/Los_Angeles')
C_V_3hourly <- monitor_timeAverage(C_V, avg.time="3 hour")
head(C_V$data, n=15)
head(C_V_3hourly$data, n=5)
}
\keyword{ws_monitor}
