% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadDaily.R
\name{loadDaily}
\alias{loadDaily}
\title{Load Recent PM2.5 Monitoring Data}
\usage{
loadDaily()
}
\value{
A \emph{ws_monitor} object with PM2.5 monitoring data.
}
\description{
Wrapper function to load and combine recent
data from AirNow, AIRSIS and WRCC:

\preformatted{
airnow <- airnow_loadDaily()
airsis <- airsis_loadDaily()
wrcc <- wrcc_loadDaily()
ws_monitor <- monitor_combine(list(airnow, airsis, wrcc))
}

The daily files are generated once a day, shortly after midnight and contain data for the
previous 45 days.

For the most recent data, use \code{loadLatest()}.

Avaialble RData and associated log files can be seen at:
\href{https://haze.airfire.org/monitoring/latest/RData/}{https://haze.airfire.org/monitoring/latest/RData/}
}
\examples{
\dontrun{
# Fail gracefully if any resources are not available
try({

ca <- loadDaily() \%>\% monitor_subset(stateCodes='CA')

}, silent = FALSE)
}
}
\seealso{
\code{\link{loadLatest}}
}
\keyword{AIRSIS}
\keyword{AirNow}
\keyword{WRCC}
