% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airnow_load.R
\name{airnow_load}
\alias{airnow_load}
\title{Load Processed AirNow Monitoring Data}
\usage{
airnow_load(year = 2017, month = NULL, parameter = "PM2.5",
  baseUrl = "https://haze.airfire.org/monitoring/AirNow/RData/")
}
\arguments{
\item{year}{desired year (integer or character representing YYYY)}

\item{month}{desired month (integer or character representing MM)}

\item{parameter}{parameter of interest}

\item{baseUrl}{base URL for AirNow meta and data files}
}
\value{
A \emph{ws_monitor} object with AirNow data.
}
\description{
Loads pre-generated .RData files containing AirNow data.

AirNow parameters include the following:
\enumerate{
\item{PM2.5}
}

Avaialble RData and associated log files can be seen at:
\href{https://haze.airfire.org/monitoring/AirNow/RData/}{https://haze.airfire.org/monitoring/AirNow/RData/}
}
\examples{
\dontrun{
airnow <- airnow_load(2017, 09)
airnow_conus <- monitor_subset(airnow, stateCodes=CONUS)
monitorLeaflet(airnow_conus)
}
}
\keyword{AirNow}
