% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_qualityControl.R
\name{airsis_qualityControl}
\alias{airsis_qualityControl}
\title{Apply Quality Control to Raw AIRSIS Dataframe}
\usage{
airsis_qualityControl(df, ...)
}
\arguments{
\item{df}{single site dataframe created by airsis_downloadData()}

\item{...}{additional parameters are passed to type-specific QC functions}
}
\value{
Cleaned up dataframe of AIRSIS monitor data.
}
\description{
Various QC steps are taken to clean up the incoming raw dataframe including:

\enumerate{
\item{Ensure GPS location data are included in each measurement record.}
\item{Remove GPS location records.}
\item{Remove measurement records with values outside of valid ranges.}
}

See the individual \code{airsis_~QualityControl()} functions for details.
}
\seealso{
\code{\link{airsis_EBAMQualityControl}}

\code{\link{airsis_ESAMQualityControl}}
}
\keyword{AIRSIS}
