% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR_determination.R
\name{plr_yoy_regression}
\alias{plr_yoy_regression}
\title{Year-on-Year Regression}
\usage{
plr_yoy_regression(
  data,
  power_var,
  time_var,
  model,
  per_year = 12,
  return_PLR = TRUE
)
}
\arguments{
\item{data}{Result of a power predictive model}

\item{power_var}{String name of the variable used as power}

\item{time_var}{String name of the variable used as time}

\item{model}{String name of the model the data was passed through}

\item{per_year}{Time step count per year based on model. 
Typically 12 for MbM, 365 for DbD.}

\item{return_PLR}{boolean; option to return PLR value, rather than
the raw regression data.}
}
\value{
Returns PLR value and error evaluated with YoY regression, if return_PLR is false
 it will return the individual YoY calculations
}
\description{
Automatically calculates Performance Loss Rate (PLR)
using year on year regression. Note that it needs data from a 
power predictive model.
}
\examples{
# build var_list
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)
                         
# Perform the power predictive modeling step
test_xbx_wbw_res <- plr_xbx_model(test_dfc, var_list, by = "week",
                                  data_cutoff = 30, predict_data = NULL)
                                  
# Calculate Performance Loss Rate
xbx_wbw_plr <- plr_yoy_regression(test_xbx_wbw_res, 
                                       power_var = 'power_var', 
                                       time_var = 'time_var',
                                       model = "xbx", 
                                       per_year = 52, 
                                       return_PLR = TRUE)


}
