% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_corrections.R
\name{plr_pvusa_model}
\alias{plr_pvusa_model}
\title{PVUSA Method for PLR Determination}
\usage{
plr_pvusa_model(
  df,
  var_list,
  by = "month",
  data_cutoff = 30,
  predict_data = NULL
)
}
\arguments{
\item{df}{A dataframe containing pv data.}

\item{var_list}{A list of the dataframe's standard variable names, obtained from
the output of \code{\link{plr_variable_check}}.}

\item{by}{String, either "day", "week", or "month". The time periods over which
to group data for regression.}

\item{data_cutoff}{The number of data points needed to keep a value in the 
final table. Regressions over less than this number and their data will be discarded.}

\item{predict_data}{optional; Dataframe; If you have preferred estimations of irradiance,
temperature, and wind speed, include them here to skip automatic generation. Format:
Irradiance, Temperature, Wind (optional).}
}
\value{
Returns dataframe of results per passed time scale from PVUSA modeling
}
\description{
This function groups data by the specified time interval
and performs a linear regression using the formula: 
\eqn{P = G_{POA} * (\beta_{0} + \beta_{1} G + \beta_{2} T_{amb} + \beta_{3} W)}.
Predicted values of irradiance, temperature, and wind speed (if applicable)
are added for reference. These values are the lowest daily high
irradiance reading (over 300), the average temperature over all data, and
the average wind speed over all data.
}
\examples{
# build var_list
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)
                         
# Perform the power predictive modeling step
test_xbx_wbw_res <- plr_pvusa_model(test_dfc, var_list, by = "week",
                                  data_cutoff = 30, predict_data = NULL)

}
