% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzQC.R
\name{getMetaFilenames}
\alias{getMetaFilenames}
\title{Parses the given mqpar.xml file (or, if not found, tries the 'txt_folder' + '/../../' folder (i.e. where the raw data should be)) to extract the full filepaths for all Raw files}
\usage{
getMetaFilenames(mqpar_file, txt_folder)
}
\arguments{
\item{mqpar_file}{Location of the mqpar.xml (can be empty, if unknown)}

\item{txt_folder}{Fallback option: path to the txt folder (which contains evidence.txt, etc)}
}
\value{
May return 'NULL' if no mqpar.xml could be found.
        Otherwise: data.frame with columns:
        \itemize{
          \item 'file' (no path), 'path' (full path incl. names)
          \item 'file_no_suffix' (as 'file' but without suffix) 
          \item 'CV' (CV term for filetype, e.g. for Thermo Raw)
        }
}
\description{
Parses the given mqpar.xml file (or, if not found, tries the 'txt_folder' + '/../../' folder (i.e. where the raw data should be)) to extract the full filepaths for all Raw files
}
