% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_MQ.R
\name{fixCalibration}
\alias{fixCalibration}
\title{Detect (and fix) MaxQuant mass recalibration columns, since they
sometimes report wrong values.}
\usage{
fixCalibration(df_evd, df_idrate = NULL, tolerance_sd_PCoutOfCal = 2,
  low_id_rate = 1)
}
\arguments{
\item{df_evd}{Evidence data.frame with columns ()}

\item{df_idrate}{Data.frame from summary.txt, giving ID rates for each raw file (cols: "ms.ms.identified....", "fc.raw.file"). Can also be NULL.}

\item{tolerance_sd_PCoutOfCal}{Maximal standard deviation allowed before considered 'failed'}

\item{low_id_rate}{Minimum ID rate in Percent before a Raw file is considered 'failed'}
}
\value{
list of data (stats, affected_raw_files, df_evd, recal_message, recal_message_post)
}
\description{
Returns a list of items for both diagnostics and possibly a fixed evidence data.frame.
Also two strings with messages are returned, which can serve as user message for
pre and post calibration status.
}

