% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pnadc.R
\name{get_pnadc}
\alias{get_pnadc}
\title{Download, label, deflate and create survey design object for PNADC microdata}
\usage{
get_pnadc(
  year,
  quarter = NULL,
  interview = NULL,
  topic = NULL,
  selected = FALSE,
  vars = NULL,
  defyear = NULL,
  defperiod = NULL,
  labels = TRUE,
  deflator = TRUE,
  design = TRUE,
  savedir = tempdir()
)
}
\arguments{
\item{year}{The year of the data to be downloaded. Must be a number between 2012 and current year. Vector not accepted.}

\item{quarter}{The quarter of the year of the data to be downloaded. Must be number from 1 to 4. Vector not accepted. If \code{NULL}, \code{interview} or \code{topic} number must be provided.}

\item{interview}{The interview number of the data to be downloaded. Must be number from 1 to 5. Vector not accepted. Using this option will get annual per interview data. If \code{NULL}, \code{quarter} or \code{topic} number must be provided.}

\item{topic}{The quarter related to the topic of the data to be downloaded. Must be number from 1 to 4. Vector not accepted. Using this option will get annual per topic data. If \code{NULL}, \code{quarter} or \code{interview} number must be provided.}

\item{selected}{Logical value. If \code{TRUE}, the specific questionnaire for selected resident will be used. If \code{FALSE}, the basic questionnaire for household and residents will be used. For more information about these supplemental topics, please check the survey official website.}

\item{vars}{Vector of variable names to be kept for analysis. Default is to keep all variables.}

\item{defyear}{The year of the deflator data to be downloaded for annual microdata. Must be a number between 2017 and the last available year. Vector not accepted. If \code{NULL}, the deflator year will be defined as the last year available for interview microdata, or as equal to \code{year} for topic microdata. When \code{quarter} is defined, this argument will be ignored. This argument will be used only if \code{deflator} was set as \code{TRUE}.}

\item{defperiod}{The quarter period of the deflator data to be downloaded for annual per topic microdata. Must be number from 1 to 4. Vector not accepted. If \code{NULL}, the deflator period will be defined as equal to \code{topic}. When \code{quarter} or \code{interview} is defined, this argument will be ignored. This argument will be used only if \code{deflator} was set as \code{TRUE}.}

\item{labels}{Logical value. If \code{TRUE}, categorical variables will presented as factors with labels corresponding to the survey's dictionary.}

\item{deflator}{Logical value. If \code{TRUE}, deflator variables will be available for use in the microdata.}

\item{design}{Logical value. If \code{TRUE}, will return an object of class \code{survey.design} or \code{svyrep.design}. It is strongly recommended to keep this parameter as \code{TRUE} for further analysis. If \code{FALSE}, only the microdata will be returned.}

\item{savedir}{Directory to save the downloaded data. Default is to use a temporary directory.}
}
\value{
An object of class \code{survey.design} or \code{svyrep.design} with the data from PNADC and its sample design, or a tibble with selected variables of the microdata, including the necessary survey design ones.
}
\description{
Core function of package. With this function only, the user can download a PNADC microdata from a year or quarter and get a sample design object ready to use with \code{survey} package functions.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/trabalho/9171-pesquisa-nacional-por-amostra-de-domicilios-continua-mensal.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
\donttest{
pnadc.svy <- get_pnadc(year=2017, quarter=4, selected=FALSE, vars=c("VD4001","VD4002"),
                       defyear=2017, defperiod=4, labels=TRUE, deflator=TRUE, design=TRUE,
                       savedir=tempdir())
# Calculating proportion of employed and unemployed people
if (!is.null(pnadc.svy)) survey::svymean(x=~VD4002, design=pnadc.svy, na.rm=TRUE)
pnadc.svy2 <- get_pnadc(year=2017, interview=5, selected=FALSE, vars=c("V4112","V4121B"),
                        defyear=2017, defperiod=4, labels=TRUE, deflator=TRUE, design=TRUE,
                        savedir=tempdir())
# Calculating average hours dedicated to the care of people or household chores
if (!is.null(pnadc.svy2)) survey::svymean(x=~V4121B, design=pnadc.svy2, na.rm=TRUE)
pnadc.svy3 <- get_pnadc(year=2017, topic=4, selected=FALSE, vars=c("S07006","S07007"),
                        defyear=2017, defperiod=4, labels=TRUE, deflator=TRUE, design=TRUE,
                        savedir=tempdir())
# Calculating proportion of cell phone for personal use with internet access
if (!is.null(pnadc.svy3)) survey::svymean(x=~S07007, design=pnadc.svy3, na.rm=TRUE)}
}
\seealso{
\link[PNADcIBGE]{read_pnadc} for reading PNADC microdata.\cr \link[PNADcIBGE]{pnadc_labeller} for labeling categorical variables from PNADC microdata.\cr \link[PNADcIBGE]{pnadc_deflator} for adding deflator variables to PNADC microdata.\cr \link[PNADcIBGE]{pnadc_design} for creating PNADC survey design object.\cr \link[PNADcIBGE]{pnadc_example} for getting the path of the quarter PNADC toy example files.
}
