% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandSelect.R
\name{bandSelect}
\alias{bandSelect}
\title{Penalized multi-band learning function}
\usage{
bandSelect(df, Nlength, Nlambda = 100, alpha = 1, Ntop = 5,
  cross = FALSE, Ncross = NULL, plot = TRUE)
}
\arguments{
\item{df}{the tbl_df data frame containing at least two variables: subject ID and activity. The function \code{form} can help prepare the data frame.}

\item{Nlength}{the length of observations necessary for each individual, note that it should be consistent among all}

\item{Nlambda}{\eqn{\lambda}'s take values from 0 to 2max(||X_k||^2), as 0 gives no penalty and the latter suppresses all \eqn{\theta}'s to 0. Therefore, we divide 2max(||X_k||^2) into Nlambda (default to be 100) \eqn{\lambda}'s to pick frequencies/harmonics/periodicities.}

\item{alpha}{the tuning parameter controlling the balance between L-1 and L-2 penalty. The default is 1, using complete Lasso/ L-1 penalty.}

\item{Ntop}{the number of frequencies/harmonics/periodicities picked for the population. The default is 5.}

\item{cross}{whether to perform cross-validation. The default is FALSE.}

\item{Ncross}{the number of groups of data for cross-validation. If cross=TRUE, the data shall be divided into Ncross groups.}

\item{plot}{whether to plot: MSE against the number of nonzero \eqn{\theta}'s, and only the points at which the number of nonzero \eqn{\theta}'s changes (as \eqn{\lambda} changes) are be plotted. The default is TRUE.}
}
\value{
if no cross-validation is conducted, return a list; if cross-validation, return a list of lists, with the last list consisting of all FFT results and cross-validation groups (showing the subject IDs leave-out /NOT used each time).

\item{topfreq}{vector of length \code{Ntop}: top frequencies selected.}

\item{mse}{vector of length \code{Nlambda}: mean squared error for each lambda (penalty). If no cross-validation, mse is calculated based on all available data; if cross-validation, mse is calculated based on the rest observations.}

\item{nonzero}{vector of length \code{Nlambda}: the number of nonzero \eqn{\theta}'s (frequencies) for each lambda (penalty).}

\item{deltazero}{vector of length \code{Nlambda}: the change in the number of nonzero \eqn{\theta}'s (frequencies) for each lambda (penalty).}

\item{lambda}{vector of length \code{Nlambda}: the value of lambda.}

\item{theta}{\code{Nfreq} by \code{Nlambda} matrix: estimated \eqn{\theta}'s (frequencies) at each lambda (penalty). Nfreq is the total number of frequencies given by FFT.}

\item{xscore}{\code{Nind} by \code{Nfreq} matrix: the original FFT scores for each individual. Nind is the number of individuals in the population, and Nfreq is the total number of frequencies given by FFT.}

\item{xprop}{\code{Nind} by \code{Nfreq} matrix: the original FFT results expressed as the proportion of variances explained by each frequency for each individual. Nind is the number of individuals in the population, and Nfreq is the total number of frequencies given by FFT.}

\item{freq}{vector of length \code{Nfreq}: list of frequencies in FFT results.}
}
\description{
In a group of individuals with physcial activity data, this function utilize Fast Fourier Transform (FFT)
and L-1/L-2 penalties to select significant harmonics/periodicities and describe the main activity pattern
(circadian rhythm) among the population.
}
\examples{
data(pa3)
re <- bandSelect(df=pa3,Nlength=1440*3,Nlambda=100,alpha=1,Ntop=5,
                 cross=FALSE,Ncross=NULL,plot=TRUE)

}
\references{
Li, X. , Kane, M. , Zhang, Y. , Sun, W. , Song, Y. , Dong, S. , Lin, Q. , Zhu, Q. , Jiang, F. & Zhao, H. (2019). Penalized Selection of Periodicities Characterizes the Consolidation of Sleep-Wake Circadian Rhythms During Early Childhood Development. Submitted.
}
\seealso{
\code{\link{form}}
}
