% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vanWaerdenTest.R
\name{vanWaerdenTest}
\alias{vanWaerdenTest}
\alias{vanWaerdenTest.default}
\alias{vanWeardenTest.default}
\alias{vanWaerdenTest.formula}
\title{van der Waerden's Normal Scores Test}
\usage{
vanWaerdenTest(x, ...)

\method{vanWaerdenTest}{default}(x, g, ...)

\method{vanWaerdenTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\description{
Performs van der Waerden's normal scores test.
}
\details{
For one-factorial designs with non-normally distributed
residuals van der Waerden's normal scores test can be performed to test
the H\eqn{_0: F_1(x) = F_2(x) = \ldots = F_k(x)} against
the H\eqn{_\mathrm{A}: F_i (x) \ne F_j(x)~ (i \ne j)} with at least
one strict inequality.
}
\note{
A tie correction is not applied in this function.
}
\examples{
vanWaerdenTest(count ~ spray, data = InsectSprays)

}
\references{
Conover, W. J., Iman, R. L. (1979) \emph{On multiple-comparisons procedures},
Tech. Rep. LA-7677-MS, Los Alamos Scientific Laboratory.

van der Waerden, B. L. (1952) Order tests for the two-sample
problem and their power, \emph{Indagationes Mathematicae} \bold{14}, 453--458.
}
\seealso{
\code{\link{kruskalTest}}, \code{\link{normalScoresTest}}
}
\keyword{htest}
\keyword{nonparametric}
