% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shirleyWilliamsTest.R
\name{shirleyWilliamsTest}
\alias{shirleyWilliamsTest}
\alias{shirleyWilliamsTest.default}
\alias{shirleyWilliamsTest.formula}
\title{Shirley-Williams Test}
\usage{
shirleyWilliamsTest(x, ...)

\method{shirleyWilliamsTest}{default}(x, g, nperm = 1000, ...)

\method{shirleyWilliamsTest}{formula}(formula, data, subset, na.action,
  nperm = 1000, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{nperm}{number of permutations for the assymptotic permutation test.
Defaults to \code{1000}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Shirley's nonparametric equivalent of William's test
for contrasting increasing dose levels of a treatment.
}
\details{
The Shirley-William test is a non-parametric step-down trend test for testing several treatment levels
with a zero control. Let there be \eqn{k} groups including the control and let
the zero dose level be indicated with \eqn{i = 0} and the highest
dose level with \eqn{i = m}, then the following \code{m = k - 1} hypotheses are tested:

\deqn{
\begin{array}{ll}
\mathrm{H}_{m}: \theta_0 = \theta_1 = \ldots = \theta_m, & \mathrm{A}_{m} = \theta_0 \le \theta_1 \le \ldots \theta_m, \theta_0 < \theta_m \\
\mathrm{H}_{m-1}: \theta_0 = \theta_1 = \ldots = \theta_{m-1}, & \mathrm{A}_{m-1} = \theta_0 \le \theta_1 \le \ldots \theta_{m-1}, \theta_0 < \theta_{m-1} \\
\vdots & \vdots \\
\mathrm{H}_{1}: \theta_0 = \theta_1, & \mathrm{A}_{1} = \theta_0 < \theta_1\\
\end{array}
}

The procedure starts from the highest dose level (\eqn{m}) to the the lowest dose level (\eqn{1}) and
stops at the first non-significant test. The consequent lowest effect dose
is the treatment level of the previous test number.

The p-values are estimated through an assymptotic boot-strap method. The p-values for H\eqn{_1}
are calculated from the t distribution with infinite degree of freedom. This function has
included the modifications as recommended by Williams (1986).
}
\note{
One may increase the number of permutations to e.g. \code{nperm = 10000}
in order to get more precise p-values. However, this will be on the expense of
computational time.
}
\examples{
## Example from Sachs (1997, p. 402)
x <- c(106, 114, 116, 127, 145,
110, 125, 143, 148, 151,
136, 139, 149, 160, 174)
g <- gl(3,5)
levels(g) <- c("0", "I", "II")

## Shirley-Williams Test
shirleyWilliamsTest(x ~ g)

}
\references{
Shirley, E., (1977), Nonparametric Equivalent of Williams Test for Contrasting Increasing
Dose Levels of a Treatment. \emph{Biometrics}, 33, 386--389.

Williams, D.A. (1986), Note on Shirley's nonparametric test for comparing
several dose levels with a zero-dose control. \emph{Biometrics} 42, 183--186.
}
\seealso{
\code{\link{sample}}
}
\concept{
StepDownTrendTest

DoseFinding
}
\keyword{htest}
\keyword{nonparametric}
