% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNfamily-class.R
\name{PLNfamily}
\alias{PLNfamily}
\title{An R6 Class to represent a collection of PLNfit}
\description{
super class for \code{\link{PLNPCAfamily}} and \code{\link{PLNnetworkfamily}}.
}
\details{
The parameter \code{control} is a list controlling the optimization with the following entries:
\itemize{
\item "covariance" character setting the model for the covariance matrix. Either "full", "diagonal", "spherical" or "genetic". Default is "full".
\item "corr_matrix": a symmetric positive definite correlation matrix used for the "genetic" model of covariance. Useless in other cases
\item "trace" integer for verbosity.
\item "inception" Set up the initialization. By default, the model is initialized with a multivariate linear model applied on
log-transformed data, and with the same formula as the one provided by the user. However, the user can provide a PLNfit (typically obtained from a previous fit),
which sometimes speeds up the inference.
\item "ftol_rel" stop when an optimization step changes the objective function by less than ftol multiplied by the absolute value of the parameter. Default is 1e-6 when n < p, 1e-8 otherwise.
\item "ftol_abs" stop when an optimization step changes the objective function by less than ftol multiplied by the absolute value of the parameter. Default is 0
\item "xtol_rel" stop when an optimization step changes every parameters by less than xtol multiplied by the absolute value of the parameter. Default is 1e-4
\item "xtol_abs" stop when an optimization step changes every parameters by less than xtol multiplied by the absolute value of the parameter. Default is 0
\item "maxeval" stop when the number of iteration exceeds maxeval. Default is 10000
\item "maxtime" stop when the optimization time (in seconds) exceeds maxtime. Default is -1 (no restriction)
\item "algorithm" the optimization method used by NLOPT among LD type, i.e. "CCSAQ", "MMA", "LBFGS", "VAR1", "VAR2". See NLOPT documentation for further details. Default is "CCSAQ".
}
}
\seealso{
\code{\link[=getModel]{getModel()}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{responses}}{the matrix of responses common to every models}

\item{\code{covariates}}{the matrix of covariates common to every models}

\item{\code{offsets}}{the matrix of offsets common to every models}

\item{\code{weights}}{the vector of observation weights}

\item{\code{inception}}{a \link{PLNfit} object, obtained when no sparsifying penalty is applied.}

\item{\code{models}}{a list of \link{PLNfit} object, one per penalty.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{criteria}}{a data frame with the values of some criteria (approximated log-likelihood, BIC, ICL, etc.) for the collection of models / fits
BIC and ICL are defined so that they are on the same scale as the model log-likelihood, i.e. with the form, loglik - 0.5 penalty}

\item{\code{convergence}}{sends back a data frame with some convergence diagnostics associated with the optimization process (method, optimal value, etc)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PLNfamily-new}{\code{PLNfamily$new()}}
\item \href{#method-PLNfamily-postTreatment}{\code{PLNfamily$postTreatment()}}
\item \href{#method-PLNfamily-getModel}{\code{PLNfamily$getModel()}}
\item \href{#method-PLNfamily-plot}{\code{PLNfamily$plot()}}
\item \href{#method-PLNfamily-show}{\code{PLNfamily$show()}}
\item \href{#method-PLNfamily-print}{\code{PLNfamily$print()}}
\item \href{#method-PLNfamily-clone}{\code{PLNfamily$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfamily-new"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfamily-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{\link{PLNfamily}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$new(responses, covariates, offsets, weights, control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{responses}}{the matrix of responses common to every models}

\item{\code{covariates}}{the matrix of covariates common to every models}

\item{\code{offsets}}{the matrix of offsets common to every models}

\item{\code{weights}}{the vector of observation weights}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{\link{PLNfamily}} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfamily-postTreatment"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfamily-postTreatment}{}}}
\subsection{Method \code{postTreatment()}}{
Update fields after optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$postTreatment()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfamily-getModel"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfamily-getModel}{}}}
\subsection{Method \code{getModel()}}{
Extract a model from a collection of models
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$getModel(var, index = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{var}}{value of the parameter (\code{rank} for PLNPCA, \code{sparsity} for PLNnetwork) that identifies the model to be extracted from the collection. If no exact match is found, the model with closest parameter value is returned with a warning.}

\item{\code{index}}{Integer index of the model to be returned. Only the first value is taken into account.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{PLNfit}} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfamily-plot"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfamily-plot}{}}}
\subsection{Method \code{plot()}}{
Lineplot of selected criteria for all models in the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$plot(criteria, reverse)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{criteria}}{A valid model selection criteria for the collection of models. Includes loglik, BIC (all), ICL (PLNPCA) and pen_loglik, EBIC (PLNnetwork)}

\item{\code{reverse}}{A logical indicating whether to plot the value of the criteria in the "natural" direction
(loglik - penalty) or in the "reverse" direction (-2 loglik + penalty). Default to FALSE, i.e use the natural direction, on
the same scale as the log-likelihood.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{ggplot2}} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfamily-show"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfamily-show}{}}}
\subsection{Method \code{show()}}{
User friendly print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$show()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfamily-print"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfamily-print}{}}}
\subsection{Method \code{print()}}{
User friendly print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PLNfamily-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PLNfamily-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfamily$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
