% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{as.top_ordering}
\alias{as.top_ordering}
\title{Coercion into top-ordering datasets}
\usage{
as.top_ordering(data, format_input = NULL, aggr = NULL,
  freq_col = NULL, ties_method = "random", ...)
}
\arguments{
\item{data}{An object containing the partial sequences to be coerced into an object of class \code{top_ordering}. The following classes are admissible for \code{data}: numeric \code{matrix}, \code{data.frame}, \code{RandData} from the \code{rankdist} package and \code{rankings} from the \code{PlackettLuce} package.}

\item{format_input}{Character string indicating the format of the \code{data} input, namely \code{"ordering"} or \code{"ranking"}. Used only when the class of the \code{data} argument is matrix or data frame. Default is \code{NULL}.}

\item{aggr}{Logical: whether the \code{data} argument collects the distinct observed sequences with the corresponding frequencies (aggregated format). Used only when the class of the \code{data} aargument is matrix or data frame. Default is \code{NULL}.}

\item{freq_col}{Integer indicating the column of the \code{data} argument containing the frequencies of the distinct observed sequences. Used only when the class of the \code{data} argument is matrix or data frame and \code{aggr} argument is \code{TRUE}. Default is \code{NULL}.}

\item{ties_method}{Character string indicating the treatment of sequences with ties (not used for data of class \code{RankData}). If \code{"remove"}, the sequences with ties are removed before acting the coercion; if \code{"random"} (default), tied positions are re-assigned at random before acting the coercion.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\value{
An object of S3 class \code{c("top_ordering","matrix")}.
}
\description{
Attempt to coerce the input data into a top-ordering dataset.
}
\details{
The coercion function \code{as.top_ordering} tries to coerce the input data into an object of class \code{top_ordering} after checking for possible partial sequences that do not satisfy the top-ordering requirements. If none of the supplied sequences satisfies the top-ordering conditions, an error message is returned. \code{NA}'s in the input \code{data} are tacitly converted into zero entries.
}
\examples{

## Coerce an object of class 'rankings' into an object of class 'top_ordering'
library(PlackettLuce)
RR <- matrix(c(1, 2, 0, 0,
4, 1, 2, 3,
2, 1, 1, 1,
1, 2, 3, 0,
2, 1, 1, 0,
1, 0, 3, 2), nrow = 6, byrow = TRUE) 
RR_rank=as.rankings(RR)
RR_rank
as.top_ordering(RR_rank, ties_method="random")

## Coerce an object of class 'RankData' into an object of class 'top_ordering'
library(rankdist) 
data(apa_partial_obj)
d_apa_top_ord=as.top_ordering(data=apa_partial_obj)
identical(d_apa,d_apa_top_ord)

## Coerce a data frame from the package prefmod into an object of class 'top_ordering'
library(prefmod)
data(carconf)
carconf_rank=carconf[,1:6]
carconf_top_ord=as.top_ordering(data=carconf_rank,format_input="ranking",aggr=FALSE)
identical(d_carconf,carconf_top_ord)

## Coerce a data frame from the package pmr into an object of class 'top_ordering'
library(pmr)
data(big4)
head(big4)
big4_top_ord=as.top_ordering(data=big4,format_input="ranking",aggr=TRUE,freq_col=5)
head(big4_top_ord)

}
\references{
Turner, H., Kormidis, I. and Firth, D. (2018). PlackettLuce: Plackett-Luce Models for Rankings. R package version 0.2-3. \url{https://CRAN.R-project.org/package=PlackettLuce}

Qian, Z. (2018). rankdist: Distance Based Ranking Models. R package version 1.1.3. \url{https://CRAN.R-project.org/package=rankdist}
}
\seealso{
\code{\link{is.top_ordering}}, \code{\link[PlackettLuce]{as.rankings}} and \code{\link[PlackettLuce]{rankings}}
}
\author{
Cristina Mollica and Luca Tardella
}
