% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate.R
\name{add_samples_c}
\alias{add_samples_c}
\title{Cartesian product of sample factors to a plate}
\usage{
add_samples_c(
  plate,
  n_rep,
  time = NA,
  conc = NA,
  factor = NA,
  dosage = NA,
  prefix = "S"
)
}
\arguments{
\item{plate}{PlateObj}

\item{n_rep}{number of samples to be added}

\item{time}{A vector representing time points}

\item{conc}{A vector representing concentration}

\item{factor}{A vector representing factor}

\item{dosage}{A vector representing dosage}

\item{prefix}{A prefix to be added before samples names. Default is "S"}
}
\value{
PlateObj
}
\description{
Cartesian product of sample factors to a plate
}
\details{
This function is a variation of `add_samples()` where size of inputs does not matter.
The function will automatically create a combination of all sample names with time, concentration and factor.
final name will be of form. Prefix-SampleName-Time-Concentration-Factor
}
