% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/injec_list.R
\name{build_injec_seq}
\alias{build_injec_seq}
\title{Create Injection Sequence}
\usage{
build_injec_seq(
  plate,
  inlet_method,
  repeat_std = 1,
  repeat_qc = 1,
  repeat_analyte = 1,
  blank_after_top_conc = TRUE,
  blank_at_end = TRUE,
  system_suitability = 0,
  blank_every_n = NULL,
  inject_vol,
  descr = "",
  prefix = Sys.Date(),
  suffix = "1",
  tray = 1,
  explore_mode = FALSE,
  conc_df = NULL
)
}
\arguments{
\item{plate}{PlateObj object}

\item{inlet_method}{file path specifying the inlet method.}

\item{repeat_std}{number of re-injections for calibration standards. Default is 1.}

\item{repeat_qc}{number of re-injections for QC wells. Default is 1}

\item{repeat_analyte}{number of re-injections for unknown samples. Default is 1}

\item{blank_after_top_conc}{If TRUE, adding blank after high concentrations of standards and QCS.}

\item{blank_at_end}{If True, adding blank at the end of queue.}

\item{system_suitability}{Number of re-injections for suitability vial.}

\item{blank_every_n}{If no QCs, frequency of injecting blanks between analytes.}

\item{inject_vol}{volume of injection in micro liters.}

\item{descr}{Run description.}

\item{prefix}{string at the beginning of the filename. Default is today's date.}

\item{suffix}{string to be added to the end of the filename. Default is "1".}

\item{tray}{Location in sample manager.}

\item{explore_mode}{options either TRUE or FALSE. Default if FALSE.}

\item{conc_df}{data.frame matching compound name to a scaling factor. Maximum 20 compounds allowed.}
}
\value{
InjecListObj object
}
\description{
Create Injection Sequence
}
\details{
explore_mode controls if exploratory samples are to be injected. A random sample from each CS and QC group will be sampled along with 1 blank sample.
}
