% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peek.R
\name{peek}
\alias{peek}
\title{peek at the results in a dplyr pipeline}
\usage{
peek(df, n = 5, message = NULL)
}
\arguments{
\item{df}{dataframe in pipeline}

\item{n}{number of rows to show}

\item{message}{give a message along with peeking at the data}
}
\description{
peek at the results in a dplyr pipeline
}
\details{
A wrapper around giving a \code{head} and \code{tail} command
 but only as a side effect so the original data frame is passed 
 along to continue on for furthermanipulation in the pipeline
}
\examples{
library(dplyr)
Theoph \%>\% select(Subject, Time, conc) \%>\% peek \%>\% group_by(Subject) \%>\% 
summarize(cmax = max(conc)) 

Theoph \%>\% select(Subject, Time, conc) \%>\% peek(message = "after select") \%>\% 
 group_by(Subject) \%>\% 
summarize(cmax = max(conc)) 

# nice for saving full objects but still seeing their output
cmax_theoph <- Theoph \%>\% select(Subject, Time, conc) \%>\% 
peek(message = "after select") \%>\% 
 group_by(Subject) \%>\% 
summarize(cmax = max(conc)) \%>\% peek 
cmax_theoph # still saves full output
}
