% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsPlotMP.R
\name{tsPlotMP}
\alias{tsPlotMP}
\title{Lattice Multi-Panel Time Series Plots}
\usage{
tsPlotMP(
  ret,
  add.grid = FALSE,
  layout = NULL,
  type = "l",
  yname = "RETURNS (\%)",
  Pct = FALSE,
  scaleType = "free",
  stripLeft = TRUE,
  main = NULL,
  lwd = 1,
  stripText.cex = 1,
  axis.cex = 1,
  color = "black",
  zeroLine = TRUE
)
}
\arguments{
\item{ret}{A multivariate xts object}

\item{add.grid}{Logical variable, if 'TRUE', type = c('l', 'g'), and if
'FALSE', type = c('l')}

\item{layout}{Numeric vector of length 2 or 3 giving the number of columns,
rows, and pages (optional) for a multipanel lattice display}

\item{type}{Character variable type of plot: 'l' for a line, 'p' for a
point, and 'b' and 'o' both denote both together, deafault 'l'}

\item{yname}{Character or expression giving label(s) for the y-axis}

\item{Pct}{Logical variable with default TRUE}

\item{scaleType}{Character variable that controls scale of y-axis, choose 
from c('same', 'free')}

\item{stripLeft}{Logical variable to choose the position of Lattice strip,
TRUE for drawing strips at the left of each panel, FALSE for drawing
strips at the top of each panel}

\item{main}{A character string, or possibly an expression, for main title}

\item{lwd}{The line width, a positive number, defaulting to 1}

\item{stripText.cex}{Numeric factor by which strip text in the plot(s)
are scaled relative to the default 1, 1.5 is 50 percent larger}

\item{axis.cex}{Numeric factor by which axis in the plot(s) are scaled
relative to default of 1, 1.5 is 50 larger larger, 0.5 is 50 percent smaller}

\item{color}{Specification of plotting color, with default black}

\item{zeroLine}{Logical variable specifying whether or not a dotted 
horizontal line is location at the zero vertical distance, default TRUE}
}
\value{
No value returned, instead a time series multi-panel Lattice plot
}
\description{
Lattice multi-panel time series plot with several plotting
style control parameters
}
\examples{
#Load the data
library(xts)
data("stocksCRSP")
dat = stocksCRSP
returns = tapply(dat$Return,list(dat$Date,dat$TickerLast),I)
ret = xts(returns[,1:5],as.yearmon(rownames(returns)))

#generate return time series plot               
tsPlotMP(ret, color = 'Blue')
tsPlotMP(ret, scaleType = "same", zeroLine = FALSE)
tsPlotMP(ret, stripLeft = FALSE, main = 'Time Series Plot')
}
\author{
Kirk Li and Doug Martin
}
