% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCO_func.R
\name{bw.L2PCO.diag}
\alias{bw.L2PCO.diag}
\title{Compute the diagonal PCO bandwith}
\usage{
bw.L2PCO.diag(x_i, nh = 40, K_name = "gaussian", binning = FALSE,
  nb = 32, tol = 1e-06, adapt_nb_bin = FALSE, nb_bin_vect = NULL)
}
\arguments{
\item{x_i}{the observations. Must be a matrix with d column and n lines (d the dimension and n the sample size)}

\item{nh}{the maximum of possible bandwiths tested. 
The default value is 40.}

\item{K_name}{name of the kernel. Can be 'gaussian', 'epanechnikov', 
or 'biweight'. The default value is 'gaussian'.}

\item{binning}{can be set to TRUE or FALSE. 
The value TRUE allows to use binning. The default value FALSE
computes the exact PCO criterion.}

\item{nb}{is the number of bins to use when binning is TRUE. 
For multivariate x_i, nb corresponds to the number of bins per dimension.}

\item{tol}{is the maximum authorized length of the interval which contains the optimal h 
for univariate data. For multivariate data, it corresponds to the length of each hypercube axe.
The golden section search stop once this value is achieved or when nh is reached 
and return the middle of the interval. Its default value is 10^(-6).}

\item{adapt_nb_bin}{is a boolean used for univariate x_i. If set to TRUE, authorises the function to increase 
the number of bins if, with nb bins, the middle of the initial interval is not an admissible solution, that is 
if the criterion at the middle is greater than the mean of the criterion at the bounds of the initial interval of search.}

\item{nb_bin_vect}{can be set to have a different number of bins on each dimension}
}
\value{
a scalar for univariate data or a vector (the diagonal of the matrix) for multivariate data corresponding to the optimal bandwidth according to the PCO criterion
}
\description{
\code{bw.L2PCO.diag} tries to minimise the PCO criterion (described and studied in Varet, S., Lacour, C., 
Massart, P., Rivoirard, V., (2019)) with a gold section search. For multivariate data, 
it searches for a diagonal matrix.
}
\examples{

# an example with simulated univariate data

# load univariate data
data("gauss_1D_sample")

# computes the optimal bandwith for the sample x_i with all parameters set to their default value 
bw.L2PCO.diag(gauss_1D_sample)


# an example with simulated multivariate data

# load multivariate data
data("gauss_mD_sample")

# computes the optimal bandwith for the sample x_i with all parameters set to their default value 
# generates a warning since the tolerance value is not reached
bw.L2PCO.diag(gauss_mD_sample)

# To avoid this warning, it is possible to increase the parameter nh
bw.L2PCO.diag(gauss_mD_sample, nh = 80)





}
\references{
Varet, S., Lacour, C., Massart, P., Rivoirard, V., (2019). \emph{Numerical performance of Penalized
Comparison to Overfitting for multivariate kernel density estimation}. hal-02002275. \url{https://hal.archives-ouvertes.fr/hal-02002275}
}
\seealso{
[stats::nrd0()], [stats::nrd()], [stats::ucv()], [stats::bcv()] and [stats::SJ()] 
for other univariate bandwidth selection and [stats::density()] to compute the associated density estimation.

[ks::Hlscv.diag()], [ks::Hbcv.diag()], [ks::ns.diag()] for other multivariate bandwidth selection.
}
