% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMRS-package.R
\docType{data}
\name{tenseness}
\alias{tenseness}
\title{Tenseness data from the Freiburg Complaint Checklist (tenseness)}
\format{A data frame containing data from the Freiburg Complaint Checklist with 2042 observations. 
All items refer to the scale \emph{Tenseness} and are measured on a 5-point Likert scale where low numbers 
correspond to low frequencies or low intensitites of the respective complaint and vice versa. 
\describe{ 
\item{Clammy hands}{Do you have clammy hands?}
\item{Sweat attacks}{Do you have sudden attacks of sweating?}
\item{Clumsiness}{Do you notice that you behave clumsy?}
\item{Wavering hands}{Are your hands wavering frequently, e.g. when lightning a cigarette or when holding a cup?}
\item{Restless hands}{Do you notice that your hands are restless?}
\item{Restless feet}{Do you notice that your feet are restless?}
\item{Twitching eyes}{Do you notice unvoluntary twitching of your eyes?}
\item{Twitching mouth}{Do you notice unvoluntary twitching of your mouth?}
 }}
\source{
ZPID (2013). PsychData of the Leibniz Institute for Psychology Information ZPID. Trier: Center for Research Data in Psychology.

Fahrenberg, J. (2010). Freiburg Complaint Checklist [Freiburger Beschwerdenliste (FBL)]. Goettingen, Hogrefe.
}
\description{
Data from the Freiburg Complaint Checklist. 
The data contain all 8 items corresponding to the scale \emph{Tenseness} for 2042 participants of the 
standardization sample of the Freiburg Complaint Checklist.
}
\examples{
\dontrun{
data(tenseness)

set.seed(1860)
samples <- sample(1:nrow(tenseness), 300)
tense_small <- tenseness[samples,]

m_small <- PCMRS(tense_small, cores = 25)
m_small
plot(m_small)

persons <- person.posterior(m_small, cores = 25)
plot(jitter(persons,100))
}
}
\references{
Tutz, Gerhard, Schauberger, Gunther and Berger, Moritz (2016): 
Response Styles in the Partial Credit Model, \emph{Department of Statistics, LMU
Munich}, Technical Report 196
}
\keyword{datasets}
