% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMLikDmvNorm}
\alias{PCMLikDmvNorm}
\title{Calculate the likelihood of a model using the standard formula for multivariate pdf}
\usage{
PCMLikDmvNorm(X, tree, model, SE = matrix(0, PCMNumTraits(model),
  PCMTreeNumTips(tree)), metaI = PCMInfo(X, tree, model, SE, verbose =
  verbose), log = TRUE, verbose = FALSE)
}
\arguments{
\item{X}{a \code{k x N} numerical matrix with possible \code{NA} and \code{NaN} entries. Each
column of X contains the measured trait values for one species (tip in tree).
Missing values can be either not-available (\code{NA}) or not existing (\code{NaN}).
Thse two values have are treated differently when calculating
likelihoods: see \code{\link{PCMPresentCoordinates}}.}

\item{tree}{a phylo object with N tips.}

\item{model}{an S3 object specifying both, the model type (class, e.g. "OU") as
well as the concrete model parameter values at which the likelihood is to be
calculated (see also Details).}

\item{SE}{a k x N matrix specifying the standard error for each measurement in
X. Alternatively, a k x k x N cube specifying an upper triangular k x k
Choleski factor of the variance covariance matrix for the measurement error
for each node i=1, ..., N.
Default: \code{matrix(0.0, PCMNumTraits(model), PCMTreeNumTips(tree))}.}

\item{metaI}{a list returned from a call to \code{PCMInfo(X, tree, model, SE)},
containing meta-data such as N, M and k.}

\item{log}{logical indicating whether a log-liklehood should be calculated. Default
is TRUE.}

\item{verbose}{logical indicating if some debug-messages should printed.}
}
\value{
a numerical value with named attributes as follows:
}
\description{
Calculate the likelihood of a model using the standard formula for multivariate pdf
}
