% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMMapModelTypesToRegimes}
\alias{PCMMapModelTypesToRegimes}
\title{#' Regimes in a model
#' @param model a PCM object
#' @param tree a phylo object or NULL. If the regimes in the model are integers and tree is not NULL,
#' then these integers are used as indexes in PCMTreeUniqueRegimes(tree). Default NULL.
#' @return a character or an integer vector giving the regime names of the models
#' @export
PCMRegimes <- function(model, tree = NULL, preorder = if(is.null(tree)) NULL else PCMTreePreorder(tree)) {
  UseMethod("PCMRegimes", model)
}}
\usage{
PCMMapModelTypesToRegimes(model, tree, ...)
}
\arguments{
\item{model}{a PCM model}

\item{tree}{a phylo object with an edge.regime member}

\item{...}{additional parameters passed to methods}
}
\value{
an integer vector with elements corresponding to the elements in
\code{PCMTreeUniqueRegimes(tree)}
}
\description{
#' @export
PCMRegimes.PCM <- function(model, tree = NULL, preorder = if(is.null(tree)) NULL else PCMTreePreorder(tree)) {
  r <- attr(model, "regimes")
  if(is.integer(r) && !is.null(tree)) {
    PCMTreeUniqueRegimes(tree, preorder)[r]
  } else {
    r
  }
}
Integer vector giving the model type index for each regime
}
\details{
This is a generic S3 method. The default implementation for the basic
class PCM returns a vector of 1's, because it assumes that a single model type
is associated with each regime. The implementation for multi-regime models (MRG)
returns the mapping attribute of the MRG object reordered to correspond to
\code{PCMTreeUniqueRegimes(tree)}.
}
