% Generated by roxygen2 (4.0.2): do not edit by hand
\name{SignificantSubcluster}
\alias{SignificantSubcluster}
\title{Subclusters with KEGG annotations significantly enriched}
\usage{
SignificantSubcluster(Dendrogram, Gene2Annotation, PPIdb, KGremove=TRUE, 
  SPoint=1, EPoint=9.7, p_value=0.001, ini.p_value=0.05)
}
\arguments{
\item{Dendrogram}{An object in the class "dendrogram" returned from the function "ProteinCluster"}

\item{Gene2Annotation}{A list that maps KEGG pathway ID to genes. The names should be gene symbols and the elements should be KEGG pathways. i.e.

    $IGSF5

    [1] "hsa04530" "hsa05120"

    $OR2T8

    [1] "hsa04740"

    $hCG_1776980

    [1] "hsa00020" "hsa00190" "hsa01100" "hsa05010" "hsa05012" "hsa05016"

    ......}

\item{PPIdb}{A 2-column data frame consisting of binary interactions where each row i.e. c(A, B) represents an undirected edge (interaction) between gene A and gene B.}

\item{KGremove}{If "TRUE", "hsa05200" and "hsa01100" will be excluded from KEGG-pathway based enrichment analysis as they are too broad.}

\item{SPoint}{The starting point for searching for the KEGG-pathway enriched subclusters}

\item{EPoint}{The endpoint for searching for the KEGG-pathway enriched subclusters}

\item{p_value}{Description for p_value}

\item{ini.p_value}{Description for ini.p_value}
}
\value{
This function identifies subclusters whose members are significantly enrichment in KEGG pathways and generate a dendrogram for these subclusters.
}
\description{
This function identifies subclusters whose members are significantly enrichment in certain KEGG pathways.
}
\seealso{
\code{\link{SignificantPairs}}, \code{\link{ProteinCluster}}, \code{\link{KEGGpredict}}, \code{\link{GOpredict}}
}

