% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ProteinCluster}
\alias{ProteinCluster}
\title{Cluster proteins based on significant protein pairs}
\usage{
ProteinCluster(Pfile, Plot=FALSE, TextScaler=50, height=10, width)
}
\arguments{
\item{Pfile}{A data frame returned from the function SignificantPairs()}

\item{Plot}{If FALSE, a dendrogram will NOT be generated}

\item{TextScaler}{Scale the size of the label in the generated PDF file}

\item{height}{The height of the generated PDF file}

\item{width}{The width of the generated PDF file}
}
\value{
This function returns an object in the class "dendrogram". If the argument "Plot" is "TRUE", it will also plot the dendrogram.
}
\description{
This function uses the p-values (or probabilities) derived from the PAND algorithm to perform agglomerative hierarchical clustering (using the unweighted group average) for proteins that form significant protein pairs.
}
\examples{
## not run
## data(dfPPI)
## OrderAll=SignificantPairs(dfPPI)
## dendMap=ProteinCluster(Pfile=OrderAll, Plot=TRUE, TextScaler=30)
}
\seealso{
\code{\link{SignificantPairs}}, \code{\link{KEGGpredict}}, \code{\link{GOpredict}}, \code{\link{SignificantSubcluster}}
}

