% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_banter.R
\name{export_banter}
\alias{export_banter}
\title{Export Data for a BANTER Model}
\usage{
export_banter(
  x,
  dropVars = NULL,
  dropSpecies = NULL,
  training = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{x}{a \linkS4class{AcousticStudy} object or
a list of \linkS4class{AcousticEvent} objects}

\item{dropVars}{a vector of the names of any variables to remove}

\item{dropSpecies}{a vector of the names of any species to exclude}

\item{training}{logical flag whether or not this will be used as a
training data set, or a value between 0 and 1 specifying what percent
of the data should be used for training (with the rest set aside
for testing). If TRUE or greater than 0, must contain species ID.
NOTE: if value is not 0, 1, \code{TRUE}, or \code{FALSE}, output
will be further split into \code{training} and \code{test} items
within the list output}

\item{verbose}{logical flag to show summary and informational messages}
}
\value{
a list with three items, \code{events}, \code{detectors}, and
  \code{na}. If value of \code{training} is not 0, 1, \code{TRUE}, or
  \code{FALSE}, output will be split into \code{training} and
  \code{test} lists that contain \code{events} and \code{detectors}.
  \code{events} is a dataframe with two columns. \code{event.id} is a
  unique identifier for each event, taken from the names of the event
  list. \code{species} is the species classification, taken from the
  \code{species} slot labelled \code{id}. \code{detectors} is a list
  of data frames containing all the detections and measurements. There is
  one list for each unique detector type found in the \code{detectors} slots
  of \code{x}. The data frames will only have columns with class
  \code{numeric}, \code{integer}, \code{factor}, or \code{logical}, and
  will also have columns named \code{UID}, \code{Id}, \code{parentUID},
  \code{sampleRate}, \code{Channel}, \code{angle}, and \code{angleError},
  removed so that these are not treated as parameters for the banter random
  forest model. The dataframes will also have columns \code{event.id} and
  \code{call.id} added. \code{na} contains the UIDs and Binary File names
  for any detections that had NA values. These cannot be used in the
  random forest model and are removed from the exported dataset.
}
\description{
Exports data from an AcousticStudy into the format
  required to run a BANTER model from the "banter" package
}
\examples{

# setting up example data
data(exStudy)
exStudy <- setSpecies(exStudy, method='pamguard')
banterData <- export_banter(exStudy)
# drop some variables
banterLess <- export_banter(exStudy, dropVars = c('peak', 'duration'))

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
