% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateUID.R
\name{updateUID}
\alias{updateUID}
\title{Update Detection UIDs}
\usage{
updateUID(db, binaries, verbose = TRUE, progress = TRUE)
}
\arguments{
\item{db}{database file to update UIDs}

\item{binaries}{folder of binary files to use for updating}

\item{verbose}{logical flag to show summary messages}

\item{progress}{logical flag to show progress bars}
}
\value{
Same database as \code{db}, but with an additional column
  "newUID" added to each detection table with updated UIDs if found.
  "newUID" will be -1 for any detections where no match was found
}
\description{
Update the UIDs of detections in a Pamguard database.
  UIDs can become mismatched when re-running data, this will attempt
  to re-associate the new UIDs in binary files with detections in the
  database
}
\examples{

\dontrun{
# not run because sample data does not exist
db <- 'MismatchedUid.sqlite3'
bin <- './BinaryFolder'
updateUID(db, bin)
}

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
