% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlierDetect.R
\name{outlierDetect}
\alias{outlierDetect}
\title{outlierDetect Function}
\usage{
outlierDetect(
  data_object,
  z_cutoff = NULL,
  plotWidth = 10,
  plotHeight = 5,
  group_column = NULL,
  cl = 2,
  fileName = NULL,
  filePATH = NULL
)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. It contains annotation
information and expression data from Bulk or single cell data.}

\item{z_cutoff}{|Z| cutoff threshold to find potential outliers (Eg.
\emph{z_cutoff}=2, equals to \code{Mean/SD} 2)}

\item{plotWidth}{User-defined plot width, Default 10 in}

\item{plotHeight}{User-defined plot height, Default 5 in}

\item{group_column}{Include group by outlier analysis (celltype, cluster)}

\item{cl}{Number of clusters. Use nCores-1 to run parallel. Default 2}

\item{fileName}{User-defined file name, Default outputFile}

\item{filePATH}{User-defined output directory \emph{PATH} Default, current
directory}
}
\value{
PALMO object with outlier_res dataframe
}
\description{
This function allows users to perform outlier analysis on bulk data by
calculating z-score. Outlier genes defined as mean/SD = |Z| > z_cutoff.
}
\examples{
\dontrun{
palmo_obj <- outlierDetect(data_object=palmo_obj, z_cutoff=2)
}
}
\keyword{outlierDetect}
