% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentree_taxonomy.R
\name{get_ott_children}
\alias{get_ott_children}
\title{Use this instead of \code{\link[rotl:tol_subtree]{rotl::tol_subtree()}} when taxa are not in synthesis tree and
you still need to get all species or an induced OpenTree subtree}
\usage{
get_ott_children(input = NULL, ott_ids = NULL, ott_rank = "species", ...)
}
\arguments{
\item{input}{Optional. A character vector of names.}

\item{ott_ids}{If not NULL, it takes this argument and ignores input. A
numeric vector of ott ids obtained with \code{\link[rotl:taxonomy_taxon_info]{rotl::taxonomy_taxon_info()}} or
\code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}} or \code{\link[=tnrs_match]{tnrs_match()}}.}

\item{ott_rank}{A character vector with the ranks you wanna get lineage children from.}

\item{...}{Other arguments to pass to \code{\link[=get_valid_children]{get_valid_children()}}.}
}
\value{
A \code{data.frame} object.
}
\description{
Use this instead of \code{\link[rotl:tol_subtree]{rotl::tol_subtree()}} when taxa are not in synthesis tree and
you still need to get all species or an induced OpenTree subtree
}
\examples{
# An example with the dog genus:

# It is currently not possible to get an OpenTree subtree of a taxon that is
#  missing from the OpenTree synthetic tree.
# The dog genus is not monophyletic in the OpenTree synthetic tree, so in
#  practice, it has no node to extract a subtree from.
# Get the Open Tree Taxonomy identifier (OTT id) for "Canis":
tnrs <- tnrs_match("Canis")

\dontrun{
rotl::tol_subtree(tnrs$ott_id[1])
#> Error: HTTP failure: 400
#> [/v3/tree_of_life/subtree] Error: node_id was not found (broken taxon).
} # end dontrun

\donttest{
ids <- tnrs$ott_id[1]
names(ids) <- tnrs$unique_name
children <- get_ott_children(ott_ids = ids) # or
# children <- get_ott_children(input = "Canis")
str(children)
ids <- children$Canis$ott_id
names(ids) <- rownames(children$Canis)
tree_children <- rotl::tol_induced_subtree(ott_ids = ids)
plot(tree_children, cex = 0.3)

# An example with flowering plants:

# orders <- get_ott_children(input = "magnoliophyta", ott_rank = "order")
# Get the number of orders of flowering plants that we have
# sum(orders$Magnoliophyta$rank == "order")

} # end donttest
}
