% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_plots.R
\name{plotly_spec}
\alias{plotly_spec}
\alias{plotly_spec.default}
\alias{plotly_spec.OpenSpecy}
\alias{heatmap_spec}
\alias{heatmap_spec.default}
\alias{heatmap_spec.OpenSpecy}
\alias{interactive_plot}
\alias{interactive_plot.default}
\alias{interactive_plot.OpenSpecy}
\title{Interactive plots for OpenSpecy objects}
\usage{
plotly_spec(x, ...)

\method{plotly_spec}{default}(x, ...)

\method{plotly_spec}{OpenSpecy}(
  x,
  x2 = NULL,
  line = list(color = "rgb(255, 255, 255)"),
  line2 = list(dash = "dot", color = "rgb(255,0,0)"),
  font = list(color = "#FFFFFF"),
  plot_bgcolor = "rgba(17, 0, 73, 0)",
  paper_bgcolor = "rgb(0, 0, 0)",
  ...
)

heatmap_spec(x, ...)

\method{heatmap_spec}{default}(x, ...)

\method{heatmap_spec}{OpenSpecy}(
  x,
  z = NULL,
  sn = NULL,
  cor = NULL,
  min_sn = NULL,
  min_cor = NULL,
  select = NULL,
  font = list(color = "#FFFFFF"),
  plot_bgcolor = "rgba(17, 0, 73, 0)",
  paper_bgcolor = "rgb(0, 0, 0)",
  colorscale = "Viridis",
  ...
)

interactive_plot(x, ...)

\method{interactive_plot}{default}(x, ...)

\method{interactive_plot}{OpenSpecy}(
  x,
  x2 = NULL,
  select = NULL,
  line = list(color = "rgb(255, 255, 255)"),
  line2 = list(dash = "dot", color = "rgb(255,0,0)"),
  font = list(color = "#FFFFFF"),
  plot_bgcolor = "rgba(17, 0, 73, 0)",
  paper_bgcolor = "rgb(0, 0, 0)",
  colorscale = "Viridis",
  ...
)
}
\arguments{
\item{x}{an \code{OpenSpecy} object containing metadata and spectral data for
the first group.}

\item{x2}{an optional second \code{OpenSpecy} object containing metadata and
spectral data for the second group.}

\item{line}{list; \code{line} parameter for \code{x}; passed to
\code{\link[plotly]{add_trace}()}.}

\item{line2}{list; \code{line} parameter for \code{x2}; passed to}

\item{font}{list; passed to \code{\link[plotly]{layout}()}.}

\item{plot_bgcolor}{color value; passed to \code{\link[plotly]{layout}()}.}

\item{paper_bgcolor}{color value; passed to \code{\link[plotly]{layout}()}.}

\item{z}{optional numeric vector specifying the intensity values for the
heatmap. If not provided, the function will use the intensity values from the
\code{OpenSpecy} object.}

\item{sn}{optional numeric value specifying the signal-to-noise ratio
threshold. If provided along with \code{min_sn}, regions with SNR below the
threshold will be excluded from the heatmap.}

\item{cor}{optional numeric value specifying the correlation threshold. If
provided along with \code{min_cor}, regions with correlation below the
threshold will be excluded from the heatmap.}

\item{min_sn}{optional numeric value specifying the minimum signal-to-noise
ratio for inclusion in the heatmap. Regions with SNR below this threshold
will be excluded.}

\item{min_cor}{optional numeric value specifying the minimum correlation for
inclusion in the heatmap. Regions with correlation below this threshold
will be excluded.}

\item{select}{optional index of the selected spectrum to highlight on the
heatmap.}

\item{colorscale}{colorscale passed to \code{\link[plotly]{add_trace}()}.}

\item{\ldots}{further arguments passed to \code{\link[plotly]{plot_ly}()}.}
}
\value{
A plotly heatmap object displaying the OpenSpecy data. A subplot
containing the heatmap and spectra plot. A plotly object displaying the
spectra from the \code{OpenSpecy} object(s).
}
\description{
These functions generate heatmaps, spectral plots, and interactive plots for
OpenSpecy data.
}
\examples{
\dontshow{data.table::setDTthreads(2)}
data("raman_hdpe")
tiny_map <- read_extdata("CA_tiny_map.zip") |> read_zip()
plotly_spec(raman_hdpe)

heatmap_spec(tiny_map, z = tiny_map$metadata$y)

sample_spec(tiny_map, size = 12) |>
  interactive_plot(select = 2, x2 = raman_hdpe)

}
\author{
Win Cowger, Zacharias Steinmetz
}
