% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpenSpecy-package.R
\docType{package}
\name{OpenSpecy-package}
\alias{OpenSpecy-package}
\alias{_PACKAGE}
\alias{openspecy}
\title{OpenSpecy: Analyze, Process, Identify, and Share Raman and (FT)IR Spectra}
\description{
Raman and (FT)IR spectral analysis tool for plastic particles and other environmental samples (Cowger et al. 2021, \doi{10.1021/acs.analchem.1c00123}). Supported features include reading spectral data files (.asp, .csv, .jdx, .spc, .spa, .0), Savitzky-Golay smoothing of spectral intensities with smooth_intens(), correcting background noise with subtr_bg() in accordance with Zhao et al. (2007) \doi{10.1366/000370207782597003}, and identifying spectra using an onboard reference library (Cowger et al. 2020, \doi{10.1177/0003702820929064}). Analyzed spectra can be shared with the Open Specy community. A Shiny app is available via run_app() or online at \url{https://openanalysis.org/openspecy/}.
}
\references{
Chabuka BK, Kalivas JH (2020). “Application of a Hybrid Fusion Classification
Process for Identification of Microplastics Based on Fourier Transform
Infrared Spectroscopy.” \emph{Applied Spectroscopy}, \strong{74}(9),
1167–1183. \doi{10.1177/0003702820923993}.

Cowger W, Gray A, Christiansen SH, Christiansen SH, Christiansen SH,
De Frond H, Deshpande AD, Hemabessiere L, Lee E, Mill L, et al. (2020).
“Critical Review of Processing and Classification Techniques for Images and
Spectra in Microplastic Research.” \emph{Applied Spectroscopy},
\strong{74}(9), 989–1010. \doi{10.1177/0003702820929064}.

Cowger, W (2021). “Library data.” \emph{OSF}. \doi{10.17605/OSF.IO/X7DPZ}.

Cowger W, Steinmetz Z, Gray A, Munno K, Lynch J, Hapich H, Primpke S,
De Frond H, Rochman C, Herodotou O (2021). “Microplastic Spectral
Classification Needs an Open Source Community: Open Specy to the Rescue!”
\emph{Analytical Chemistry}, \strong{93}(21), 7543–7548.
\doi{10.1021/acs.analchem.1c00123}.

Primpke S, Wirth M, Lorenz C, Gerdts G (2018). “Reference Database Design
for the Automated Analysis of Microplastic Samples Based on Fourier
Transform Infrared (FTIR) Spectroscopy.” \emph{Analytical and Bioanalytical
Chemistry}, \strong{410}(21), 5131–5141. \doi{10.1007/s00216-018-1156-x}.

Savitzky A, Golay MJ (1964). “Smoothing and Differentiation of Data by
Simplified Least Squares Procedures.” \emph{Analytical Chemistry},
\strong{36}(8), 1627--1639.

Zhao J, Lui H, McLean DI, Zeng H (2007). “Automated Autofluorescence
Background Subtraction Algorithm for Biomedical Raman Spectroscopy.”
\emph{Applied Spectroscopy}, \strong{61}(11), 1225–1232.
\doi{10.1366/000370207782597003}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/wincowgerDEV/OpenSpecy-package/}
  \item Report bugs at \url{https://github.com/wincowgerDEV/OpenSpecy-package/issues/}
}

}
\author{
\strong{Maintainer}: Win Cowger \email{wincowger@gmail.com} (\href{https://orcid.org/0000-0001-9226-3104}{ORCID})

Authors:
\itemize{
  \item Zacharias Steinmetz \email{steinmetz-z@uni-landau.de} (\href{https://orcid.org/0000-0001-6675-5033}{ORCID})
}

Other contributors:
\itemize{
  \item Andrew Gray (\href{https://orcid.org/0000-0003-2252-7367}{ORCID}) [contributor]
  \item Hannah Hapich (\href{https://orcid.org/0000-0003-0000-6632}{ORCID}) [contributor]
  \item Jennifer Lynch (\href{https://orcid.org/0000-0003-3572-8782}{ORCID}) [contributor, data contributor]
  \item Hannah De Frond (\href{https://orcid.org/0000-0003-1199-0727}{ORCID}) [contributor, data contributor]
  \item Keenan Munno (\href{https://orcid.org/0000-0003-2916-5944}{ORCID}) [contributor, data contributor]
  \item Chelsea Rochman (\href{https://orcid.org/0000-0002-7624-711X}{ORCID}) [contributor, data contributor]
  \item Sebastian Primpke (\href{https://orcid.org/0000-0001-7633-8524}{ORCID}) [contributor, data contributor]
  \item Orestis Herodotou [contributor, data contributor]
}

}
\keyword{internal}
