% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_spec.R
\name{read_text}
\alias{read_text}
\alias{read_asp}
\alias{read_spa}
\alias{read_jdx}
\alias{read_spc}
\alias{read_0}
\alias{read_extdata}
\title{Read spectral data}
\usage{
read_text(
  file = ".",
  cols = NULL,
  method = "read.csv",
  share = NULL,
  id = paste(digest(Sys.info()), digest(sessionInfo()), sep = "/"),
  ...
)

read_asp(
  file = ".",
  share = NULL,
  id = paste(digest(Sys.info()), digest(sessionInfo()), sep = "/"),
  ...
)

read_spa(
  file = ".",
  share = NULL,
  id = paste(digest(Sys.info()), digest(sessionInfo()), sep = "/"),
  ...
)

read_jdx(
  file = ".",
  share = NULL,
  id = paste(digest(Sys.info()), digest(sessionInfo()), sep = "/"),
  ...
)

read_spc(
  file = ".",
  share = NULL,
  id = paste(digest(Sys.info()), digest(sessionInfo()), sep = "/"),
  ...
)

read_0(
  file = ".",
  share = NULL,
  id = paste(digest(Sys.info()), digest(sessionInfo()), sep = "/"),
  ...
)

read_extdata(file = NULL)
}
\arguments{
\item{file}{file to be read from.}

\item{cols}{character vector of \code{length = 2} indicating the colum names
for the wavenumber and intensity; if \code{NULL} columns are guessed.}

\item{method}{submethod to be used for reading text files; defaults to
\link[utils]{read.csv} but \link[data.table]{fread} works as well.}

\item{share}{defaults to \code{NULL}; needed to share spectra with the
Open Specy community; see \code{\link{share_spec}()} for details.}

\item{id}{a unique user and/or session ID; defaults to
\code{paste(digest(Sys.info()), digest(sessionInfo()), sep = "/")}.}

\item{\ldots}{further arguments passed to the submethods.}
}
\value{
All \code{read_*()} functions return data frames containing two columns
named \code{"wavenumber"} and \code{"intensity"}.
}
\description{
Functions for reading spectral data types including .asp, .jdx,
.spc, .spa, .0, and .csv.
}
\details{
\code{read_spc()} and \code{read_jdx()} are just a wrapper around the
functions provided by the \link[hyperSpec:hyperSpec-package]{hyperSpec}
package.
Other functions have been adapted various online sources.
All functions convert datasets to a 2 column table with one column labeled
"wavenumber" and the other "intensity". There are many unique iterations of
spectral file formats so there may be bugs in the file conversion.
Please contact us if you identify any.
}
\examples{
read_text(read_extdata("raman_hdpe.csv"))
read_asp(read_extdata("ftir_ldpe_soil.asp"))
read_0(read_extdata("ftir_ps.0"))

}
\seealso{
\code{\link[hyperSpec]{read.jdx}()}; \code{\link[hyperSpec]{read.spc}()};
\code{\link[hexView]{readRaw}()}; \code{\link{share_spec}()}
}
\author{
Zacharias Steinmetz, Win Cowger
}
