% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash_functions.R
\name{average_hash}
\alias{average_hash}
\title{calculation of the 'average hash' of an image}
\usage{
average_hash(gray_image, hash_size = 8, MODE = "hash",
  resize = "nearest")
}
\arguments{
\item{gray_image}{a (2-dimensional) matrix or data frame}

\item{hash_size}{an integer specifying the hash size (should be less than number of rows or columns of the gray_image)}

\item{MODE}{one of 'hash' (returns the hash of the image), 'binary' (returns binary identifier of the image)}

\item{resize}{corresponds to one of 'nearest', 'bilinear' (resizing method)}
}
\value{
either a hash-string or a binary vector
}
\description{
This function calculates the average hash of an image
}
\details{
The function is a modification of the 'average_hash' function of the imagehash package [ please consult the COPYRIGHT file ]. The average hash works 
in the following way : 1st convert to grayscale, 2nd, reduce the size of an image (for instance to an 8x8 image, to further simplify 
the number of computations), 3rd average the resulting colors (for an 8x8 image we average 64 colors), 4th compute the bits by comparing if each color value 
is above or below the mean, 5th construct the hash.
}
\examples{

image = readImage(system.file("tmp_images", "1.png", package = "OpenImageR"))

image = rgb_2gray(image)

res_hash = average_hash(image, hash_size = 8, MODE = 'hash')

res_binary = average_hash(image, hash_size = 8, MODE = 'binary')

}
