% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_rows_0.R
\name{bind_rows_0}
\alias{bind_rows_0}
\title{Bind rows of multiple data frames with zero fill}
\usage{
bind_rows_0(...)
}
\arguments{
\item{...}{Data frames to combine, passed into bind_rows (see dplyr documentation)}
}
\description{
A version of bind_rows out of dplyr that
    fills non-common columns with zeroes instead of NA.
    Gives an error if any of the input data contains NA already.
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(OncoBayes2.MC.warmup=10, OncoBayes2.MC.iter=20, OncoBayes2.MC.chains=1)

library(tibble)

dose_info_A <- tibble(
   group_id = "hist_A",
   drug_A = 1
 )

 dose_info_B <- tibble(
   group_id = "hist_B",
   drug_B = 100 * (1:2)
 )

bind_rows_0(dose_info_A, dose_info_B)

## Recover user set sampling defaults
options(.user_mc_options)

}
