% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseConceptIdCounts.R
\name{summariseConceptIdCounts}
\alias{summariseConceptIdCounts}
\title{Summarise concept use in patient-level data}
\usage{
summariseConceptIdCounts(
  cdm,
  omopTableName,
  countBy = "record",
  year = FALSE,
  sex = FALSE,
  ageGroup = NULL,
  sample = NULL,
  dateRange = NULL
)
}
\arguments{
\item{cdm}{A cdm object}

\item{omopTableName}{A character vector of the names of the tables to
summarise in the cdm object.}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts}

\item{year}{TRUE or FALSE. If TRUE code use will be summarised by year.}

\item{sex}{TRUE or FALSE. If TRUE code use will be summarised by sex.}

\item{ageGroup}{A list of ageGroup vectors of length two. Code use will be
thus summarised by age groups.}

\item{sample}{An integer to sample the tables to only that number of records.
If NULL no sample is done.}

\item{dateRange}{A vector of two dates defining the desired study period.
Only the \code{start_date} column of the OMOP table is checked to ensure it falls within this range.
If \code{dateRange} is \code{NULL}, no restriction is applied.}
}
\value{
A summarised_result object with results overall and, if specified, by
strata.
}
\description{
Summarise concept use in patient-level data
}
\examples{
\donttest{
library(OmopSketch)
library(CDMConnector)
library(duckdb)

requireEunomia()
con <- dbConnect(duckdb(), eunomiaDir())
cdm <- cdmFromCon(con = con, cdmSchema = "main", writeSchema = "main")

summariseConceptIdCounts(cdm, "condition_occurrence")
}

}
