% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_mixed_model.R
\name{olink_lmer_posthoc}
\alias{olink_lmer_posthoc}
\title{Function which performs a linear mixed model posthoc per protein.}
\usage{
olink_lmer_posthoc(
  df,
  olinkid_list = NULL,
  variable,
  outcome = "NPX",
  random,
  model_formula,
  effect,
  effect_formula,
  covariates = NULL,
  mean_return = FALSE,
  post_hoc_padjust_method = "tukey",
  verbose = TRUE
)
}
\arguments{
\item{df}{NPX data frame in long format with at least protein name (Assay), OlinkID, UniProt, 1-2 variables with at least 2 levels and subject ID.}

\item{olinkid_list}{Character vector of OlinkID's on which to perform post hoc analysis. If not specified, all assays in df are used.}

\item{variable}{Single character value or character array.
Variable(s) to test. If length > 1, the included variable names will be used in crossed analyses .
Also takes ':' or '*' notation.}

\item{outcome}{Character. The dependent variable. Default: NPX.}

\item{random}{Single character value or character array.}

\item{model_formula}{(optional) Symbolic description of the model to be fitted in standard formula notation (e.g. "NPX~A*B + (1|ID)"). If provided, this will override the \code{outcome}, \code{variable} and \code{covariates} arguments. Can be a string or of class \code{stats::formula()}.}

\item{effect}{Term on which to perform post-hoc. Character vector. Must be subset of or identical to variable.}

\item{effect_formula}{(optional) A character vector specifying the names of the predictors over which estimated marginal means are desired as defined in the \code{emmeans} package. May also be a formula. If provided, this will override the \code{effect} argument. See \code{?emmeans::emmeans()} for more information.}

\item{covariates}{Single character value or character array. Default: NULL. Covariates to include. Takes ':' or '*' notation. Crossed analysis will not be inferred from main effects.}

\item{mean_return}{Boolean. If true, returns the mean of each factor level rather than the difference in means (default). Note that no p-value is returned for mean_return = TRUE and no adjustment is performed.}

\item{post_hoc_padjust_method}{P-value adjustment method to use for post-hoc comparisons within an assay. Options include \code{tukey}, \code{sidak}, \code{bonferroni} and \code{none}.}

\item{verbose}{Boolean. Default: True. If information about removed samples, factor conversion and final model formula is to be printed to the console.}
}
\value{
A "tibble" containing the results of the pairwise comparisons between given variable levels for proteins specified in olinkid_list (or full df).
Columns include:
\itemize{
 \item{Assay:} "character" Protein symbol
 \item{OlinkID:} "character" Olink specific ID
 \item{UniProt:} "character" Olink specific ID
 \item{Panel:} "character" Name of Olink Panel
 \item{term:} "character" term in model
 \item{contrast:} "character" the groups that were compared
 \item{estimate:} "numeric" difference in mean NPX between groups
 \item{conf.low:} "numeric" confidence interval for the mean (lower end)
 \item{conf.high:} "numeric" confidence interval for the mean (upper end)
 \item{Adjusted_pval:} "numeric" adjusted p-value for the test
 \item{Threshold:} "character" if adjusted p-value is significant or not (< 0.05)
}
}
\description{
Similar to olink_lmer but performs a post hoc analysis based on a linear mixed model effects model using lmerTest::lmer and emmeans::emmeans on proteins.
See \code{olink_lmer} for details of input notation. \cr\cr
The function handles both factor and numerical variables and/or covariates.
Differences in estimated marginal means are calculated for all pairwise levels of a given variable.
Degrees of freedom are estimated using Satterthwaite’s approximation.
The posthoc test for a numerical variable compares the difference in means of the outcome variable (default: NPX) for 1 standard deviation difference in the numerical variable, e.g.
mean NPX at mean(numerical variable) versus mean NPX at mean(numerical variable) + 1*SD(numerical variable).
The output tibble is arranged by ascending Tukey adjusted p-values.
}
\examples{
\donttest{

library(dplyr)

lmer_results <- olink_lmer(df = npx_data1,
                           variable=c("Time", 'Treatment'),
                           random = c('Subject'))

assay_list <- lmer_results \%>\%
    filter(Threshold == 'Significant' & term == 'Time:Treatment') \%>\%
    select(OlinkID) \%>\%
    distinct() \%>\%
    pull()

results_lmer_posthoc <- olink_lmer_posthoc(df = npx_data1,
                                           olinkid_list = assay_list,
                                           variable=c("Time", 'Treatment'),
                                           effect = 'Time:Treatment',
                                           random = 'Subject',
                                           verbose = TRUE)

#Estimate treated vs untreated at each timepoint


results_lmer_posthoc <- olink_lmer_posthoc(df = npx_data1,
                                           olinkid_list = assay_list,
                                           model_formula = "NPX~Time*Treatment+(1|Subject)",
                                           effect_formula = "pairwise~Treatment|Time",
                                           verbose = TRUE)
}

}
