/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import org.andwellness.xml.datagenerator.SurveyCreator;
import org.andwellness.xml.datagenerator.generator.JSONGeneratorType;
import org.andwellness.xml.datagenerator.generator.JSONGeneratorTypeFactory;
import org.andwellness.xml.datagenerator.model.Survey;
import org.andwellness.xml.datagenerator.utility.JSONUtility;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.json.JSONException;

public class DataGenerator {
    private static Logger _logger = Logger.getLogger(DataGenerator.class);

    public static void main(String[] args) {
        int numberDays = 0;
        int numberSurveysPerDay = 0;
        BufferedReader configReader = null;
        BufferedWriter outputWirter = null;
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
        if (args.length < 5) {
            DataGenerator.usage();
            System.exit(1);
        }
        String configFileName = args[0];
        String outputFileName = args[3];
        String jsonType = args[4];
        try {
            numberDays = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            System.err.println("The second argument must be an integer.");
            System.exit(1);
        }
        try {
            numberSurveysPerDay = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            System.err.println("The third argument must be an integer.");
            System.exit(1);
        }
        try {
            configReader = new BufferedReader(new FileReader(configFileName));
        }
        catch (FileNotFoundException err) {
            System.err.println("The configuration file was not found: " + configFileName);
            System.exit(1);
        }
        try {
            outputWirter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outputFileName)));
        }
        catch (FileNotFoundException err) {
            System.err.println("Cannot write to file: " + outputFileName);
            System.exit(1);
        }
        DataGenerator generator = new DataGenerator();
        try {
            generator.run(configReader, numberDays, numberSurveysPerDay, outputWirter, jsonType);
        }
        catch (ValidityException e) {
            System.err.println("Configuration xml file contain invalid XML.");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (ParsingException e) {
            System.err.println("Cannot parse XML configuration file.");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Cannot read the input or output file.");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (JSONException e) {
            System.err.println("The program created invalid JSON (this is bad)");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            System.err.println("One of the arguments is invalid.");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Unknown exception, aborting!");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    public static void usage() {
        System.out.println("Generates JSON from an AndWellness XMl configuration file that specifiies any number of surveys.  Does not");
        System.out.println("do validation, assumes the XML is already validated by the AndWellnessConfiguration validator.");
        System.out.println();
        System.out.println("Usage: java -jar andwellness-data-generator-$version.jar $configFilename $numDays $numPerDay $outFilename $generatorType");
        System.out.println("    $configFilename - The filename with the XML configuration.");
        System.out.println("    $numDay - The number of days of surveys to generator, starting now and working backwards.");
        System.out.println("    $numPerDay - The number of surveys to generate per day.");
        System.out.println("    $outFilename - The file to output the generated JSON.");
        System.out.println("    $generatorType - \"upload\" to generate json to upload to the server, \"download\" to generate json to download from the server.");
    }

    public void run(Reader xmlConfigReader, int numDays, int surveysPerDay, Writer outputWriter, String generatorType) throws ValidityException, ParsingException, IOException, JSONException {
        _logger.info("Reading XML configuration and generating surveys...");
        Builder builder = new Builder();
        Document document = builder.build(xmlConfigReader);
        Element root = document.getRootElement();
        List<Survey> surveyList = this.generateMultipleResponses(root, numDays, surveysPerDay);
        _logger.info("Generated " + surveyList.size() + " surveys, translating to JSON...");
        JSONGeneratorType jsonGenerator = JSONGeneratorTypeFactory.getGenerator(generatorType);
        Object translatedJSON = jsonGenerator.translateSurveysToJson(surveyList);
        _logger.info("Surveys successfully translated to JSON, outputting...");
        JSONUtility.JSONWriter(outputWriter, translatedJSON, false);
        _logger.info("Data generation successful!");
    }

    private List<Survey> generateMultipleResponses(Element root, int numberDays, int numberSurveysPerDay) {
        ArrayList<Survey> responseList = new ArrayList<Survey>();
        int numberSecondsBetweenSurveys = 86400 / numberSurveysPerDay;
        GregorianCalendar calendar = new GregorianCalendar();
        for (int i = 0; i < numberDays * numberSurveysPerDay; ++i) {
            responseList.addAll(this.generateSingleResponse(root, calendar.getTime()));
            ((Calendar)calendar).add(13, -1 * numberSecondsBetweenSurveys);
        }
        return responseList;
    }

    private List<Survey> generateSingleResponse(Element root, Date creationDate) {
        ArrayList<Survey> createdSurveys = new ArrayList<Survey>();
        Nodes surveys = root.query("//survey");
        int numberOfSurveys = surveys.size();
        for (int x = 0; x < numberOfSurveys; ++x) {
            Node survey = surveys.get(x);
            SurveyCreator surveyCreator = new SurveyCreator();
            createdSurveys.add(surveyCreator.createSurvey(survey, creationDate));
        }
        return createdSurveys;
    }
}

