/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.model;

import java.util.HashMap;
import java.util.Map;
import org.andwellness.xml.datagenerator.model.Response;

public class DataPoint
implements Response {
    private String id;
    private Object value;
    private DisplayType displayType;
    private PromptType promptType;
    private boolean isSkipped;
    private boolean isNotDisplayed;
    Map<String, Object> metadata = new HashMap<String, Object>();

    public DataPoint() {
    }

    public DataPoint(String _id) {
        this.id = _id;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    public String getId() {
        return this.id;
    }

    public void setValue(Object _value) {
        this.value = _value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setUnit(String _unit) {
        this.metadata.put("unit", _unit);
    }

    public String getUnit() {
        return (String)this.metadata.get("unit");
    }

    public void setDatetime(String _datetime) {
        this.metadata.put("datetime", _datetime);
    }

    public String getDatetime() {
        return (String)this.metadata.get("datetime");
    }

    public void setTz(String _tz) {
        this.metadata.put("tz", _tz);
    }

    public String getTz() {
        return (String)this.metadata.get("tz");
    }

    public void setLat(String _lat) {
        this.metadata.put("lat", _lat);
    }

    public String getLat() {
        return (String)this.metadata.get("lat");
    }

    public void setLon(String _lon) {
        this.metadata.put("lon", _lon);
    }

    public String getLon() {
        return (String)this.metadata.get("lon");
    }

    public void setDisplayType(DisplayType _displayType) {
        this.displayType = _displayType;
    }

    public void setDisplayType(String _displayType) {
        if (DisplayType.category.toString().equals(_displayType)) {
            this.displayType = DisplayType.category;
        } else if (DisplayType.event.toString().equals(_displayType)) {
            this.displayType = DisplayType.event;
        } else if (DisplayType.measurement.toString().equals(_displayType)) {
            this.displayType = DisplayType.measurement;
        } else if (DisplayType.count.toString().equals(_displayType)) {
            this.displayType = DisplayType.count;
        } else if (DisplayType.metadata.toString().equals(_displayType)) {
            this.displayType = DisplayType.metadata;
        } else {
            throw new IllegalArgumentException("Display type does not exist: " + _displayType);
        }
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setPromptType(PromptType _promptType) {
        this.promptType = _promptType;
    }

    public void setPromptType(String _promptType) {
        if (PromptType.timestamp.toString().equals(_promptType)) {
            this.promptType = PromptType.timestamp;
        } else if (PromptType.number.toString().equals(_promptType)) {
            this.promptType = PromptType.number;
        } else if (PromptType.hours_before_now.toString().equals(_promptType)) {
            this.promptType = PromptType.hours_before_now;
        } else if (PromptType.text.toString().equals(_promptType)) {
            this.promptType = PromptType.text;
        } else if (PromptType.multi_choice.toString().equals(_promptType)) {
            this.promptType = PromptType.multi_choice;
        } else if (PromptType.single_choice.toString().equals(_promptType)) {
            this.promptType = PromptType.single_choice;
        } else if (PromptType.single_choice_custom.toString().equals(_promptType)) {
            this.promptType = PromptType.single_choice_custom;
        } else if (PromptType.multi_choice_custom.toString().equals(_promptType)) {
            this.promptType = PromptType.multi_choice_custom;
        } else if (PromptType.photo.toString().equals(_promptType)) {
            this.promptType = PromptType.photo;
        } else {
            throw new IllegalArgumentException("Prompt type does not exist: " + _promptType);
        }
    }

    public PromptType getPromptType() {
        return this.promptType;
    }

    public void setSkipped() {
        this.isSkipped = true;
    }

    public boolean isSkipped() {
        return this.isSkipped;
    }

    public void setNotDisplayed() {
        this.isNotDisplayed = true;
    }

    public boolean isNotDisplayed() {
        return this.isNotDisplayed;
    }

    public boolean isMetadata() {
        return DisplayType.metadata.equals((Object)this.displayType);
    }

    public String toString() {
        return "type " + this.promptType.toString() + " id " + this.id + " value " + this.value;
    }

    public boolean equals(Object toCompare) {
        if (toCompare instanceof DataPoint) {
            return this.getId().equals(((DataPoint)toCompare).getId());
        }
        return false;
    }

    public static enum PromptType {
        timestamp,
        number,
        hours_before_now,
        text,
        multi_choice,
        single_choice,
        single_choice_custom,
        multi_choice_custom,
        photo,
        remote_activity;

    }

    public static enum DisplayType {
        category,
        measurement,
        event,
        count,
        metadata;

    }
}

